/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import com.frostwire.concurrent.concurrent.ExecutorsHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;
import org.limewire.setting.SettingsGroup;

public final class SettingsGroupManager {
    private static final SettingsGroupManager INSTANCE = new SettingsGroupManager();
    private final Collection<SettingsGroup> PROPS = Collections.synchronizedList(new ArrayList());
    private final Executor executor = ExecutorsHelper.newFixedSizeThreadPool(1, "SettingsHandlerEventDispatcher");

    private SettingsGroupManager() {
    }

    public static SettingsGroupManager instance() {
        return INSTANCE;
    }

    void addSettingsGroup(SettingsGroup group) {
        this.PROPS.add(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Collection<SettingsGroup> collection = this.PROPS;
        synchronized (collection) {
            for (SettingsGroup group : this.PROPS) {
                group.reload();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        boolean any = false;
        Collection<SettingsGroup> collection = this.PROPS;
        synchronized (collection) {
            for (SettingsGroup group : this.PROPS) {
                any |= group.save();
            }
        }
        return any;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean revertToDefault() {
        boolean any = false;
        Collection<SettingsGroup> collection = this.PROPS;
        synchronized (collection) {
            for (SettingsGroup group : this.PROPS) {
                any |= group.revertToDefault();
            }
        }
        return any;
    }

    void execute(Runnable evt) {
        this.executor.execute(evt);
    }
}

