/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.Properties;
import org.limewire.setting.AbstractNumberSetting;

public class FloatSetting
extends AbstractNumberSetting<Float> {
    private float value;

    FloatSetting(Properties defaultProps, Properties props, String key, float defaultFloat) {
        super(defaultProps, props, key, String.valueOf(defaultFloat), false, null, null);
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.setValueInternal(String.valueOf(value));
    }

    @Override
    protected void loadValue(String sValue) {
        try {
            this.value = Float.parseFloat(sValue.trim());
        }
        catch (NumberFormatException nfe) {
            this.revertToDefault();
        }
    }

    @Override
    protected Comparable<Float> convertToComparable(String value) {
        return Float.valueOf(value);
    }
}

