/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.Collection;
import org.limewire.setting.SettingsGroup;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.setting.evt.SettingsGroupEvent;
import org.limewire.setting.evt.SettingsGroupListener;

abstract class AbstractSettingsGroup
implements SettingsGroup {
    private Collection<SettingsGroupListener> listeners;

    AbstractSettingsGroup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SettingsGroupListener[] getSettingsGroupListeners() {
        AbstractSettingsGroup abstractSettingsGroup = this;
        synchronized (abstractSettingsGroup) {
            if (this.listeners == null) {
                return null;
            }
            return this.listeners.toArray(new SettingsGroupListener[0]);
        }
    }

    boolean getShouldSave() {
        return true;
    }

    void fireSettingsEvent(SettingsGroupEvent.EventType type) {
        this.fireSettingsEvent(new SettingsGroupEvent(type, this));
    }

    private void fireSettingsEvent(SettingsGroupEvent evt) {
        if (evt == null) {
            throw new NullPointerException("SettingsEvent is null");
        }
        SettingsGroupListener[] listeners = this.getSettingsGroupListeners();
        if (listeners != null) {
            Runnable command = () -> {
                for (SettingsGroupListener l : listeners) {
                    l.settingsGroupChanged(evt);
                }
            };
            SettingsGroupManager.instance().execute(command);
        }
    }
}

