/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.Collection;
import java.util.Properties;
import org.limewire.setting.Setting;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;

public abstract class AbstractSetting
implements Setting {
    final String DEFAULT_VALUE;
    private final Properties DEFAULT_PROPS;
    private final Properties PROPS;
    private final String KEY;
    private boolean alwaysSave = false;
    private boolean isPrivate = false;
    private Collection<SettingListener> listeners = null;

    AbstractSetting(Properties defaultProps, Properties props, String key, String defaultValue) {
        this.DEFAULT_PROPS = defaultProps;
        this.PROPS = props;
        this.KEY = key;
        this.DEFAULT_VALUE = defaultValue;
        if (this.DEFAULT_PROPS.containsKey(key)) {
            throw new IllegalArgumentException("(AbstractSetting constructor) duplicate setting key: " + key);
        }
        this.DEFAULT_PROPS.put(this.KEY, defaultValue);
        this.loadValue(defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SettingListener[] getSettingListeners() {
        AbstractSetting abstractSetting = this;
        synchronized (abstractSetting) {
            if (this.listeners == null) {
                return null;
            }
            return this.listeners.toArray(new SettingListener[0]);
        }
    }

    @Override
    public void reload() {
        String value = this.PROPS.getProperty(this.KEY);
        if (value == null) {
            value = this.DEFAULT_VALUE;
        }
        if (this.isDefault()) {
            this.PROPS.setProperty(this.KEY, this.DEFAULT_VALUE);
        }
        this.loadValue(value);
        this.fireSettingEvent(SettingEvent.EventType.RELOAD);
    }

    @Override
    public boolean revertToDefault() {
        if (!this.isDefault()) {
            this.setValueInternal(this.DEFAULT_VALUE);
            this.fireSettingEvent(SettingEvent.EventType.REVERT_TO_DEFAULT);
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldAlwaysSave() {
        return this.alwaysSave;
    }

    @Override
    public AbstractSetting setAlwaysSave(boolean alwaysSave) {
        if (this.alwaysSave != alwaysSave) {
            this.alwaysSave = alwaysSave;
            this.fireSettingEvent(SettingEvent.EventType.ALWAYS_SAVE_CHANGED);
        }
        return this;
    }

    @Override
    public Setting setPrivate(boolean isPrivate) {
        if (this.isPrivate != isPrivate) {
            this.isPrivate = isPrivate;
            this.fireSettingEvent(SettingEvent.EventType.PRIVACY_CHANGED);
        }
        return this;
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public boolean isDefault() {
        String value = this.PROPS.getProperty(this.KEY);
        if (value == null) {
            return true;
        }
        return value.equals(this.DEFAULT_PROPS.getProperty(this.KEY));
    }

    @Override
    public String getKey() {
        return this.KEY;
    }

    @Override
    public String getValueAsString() {
        String prop = this.PROPS.getProperty(this.KEY);
        return prop == null ? this.DEFAULT_VALUE : prop;
    }

    void setValueInternal(String value) {
        String old = this.PROPS.getProperty(this.KEY);
        if (old == null || !old.equals(value)) {
            this.PROPS.setProperty(this.KEY, value);
            this.loadValue(value);
            this.fireSettingEvent(SettingEvent.EventType.VALUE_CHANGED);
        }
    }

    protected abstract void loadValue(String var1);

    public String toString() {
        return this.KEY + "=" + this.getValueAsString();
    }

    private void fireSettingEvent(SettingEvent.EventType type) {
        this.fireSettingEvent(new SettingEvent(type, this));
    }

    private void fireSettingEvent(SettingEvent evt) {
        if (evt == null) {
            throw new NullPointerException("SettingEvent is null");
        }
        SettingListener[] listeners = this.getSettingListeners();
        if (listeners != null) {
            Runnable command = () -> {
                for (SettingListener l : listeners) {
                    l.settingChanged(evt);
                }
            };
            SettingsGroupManager.instance().execute(command);
        }
    }

    public <T> T getDefaultValue() {
        return (T)this.DEFAULT_PROPS.getProperty(this.KEY);
    }
}

