/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Iterator;
import java.util.LinkedList;
import org.limewire.collection.AutoCompleteDictionary;
import org.limewire.collection.StringTrie;

public class StringTrieSet
implements AutoCompleteDictionary,
Iterable<String> {
    private final transient StringTrie<String> map;

    public StringTrieSet(boolean caseSensitive) {
        this.map = new StringTrie(caseSensitive);
    }

    @Override
    public void addEntry(String data) {
        if (!this.contains(data)) {
            this.map.add(data, data);
        }
    }

    private boolean contains(String data) {
        return this.map.get(data) != null;
    }

    @Override
    public boolean removeEntry(String data) {
        return this.map.remove(data);
    }

    @Override
    public String lookup(String data) {
        Iterator<String> it = this.map.getPrefixedBy(data);
        if (!it.hasNext()) {
            return null;
        }
        return it.next();
    }

    @Override
    public Iterator<String> iterator() {
        return this.map.getIterator();
    }

    @Override
    public Iterator<String> iterator(String s) {
        return this.map.getPrefixedBy(s);
    }

    @Override
    public void clear() {
        LinkedList<String> l = new LinkedList<String>();
        for (String string : this) {
            l.add(string);
        }
        for (String string : l) {
            this.removeEntry(string);
        }
    }
}

