/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import org.limewire.collection.FixedsizeForgetfulHashMap;

public class FixedsizeForgetfulHashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable {
    private static final Object PRESENT = new Object();
    private transient FixedsizeForgetfulHashMap<E, Object> map;

    public FixedsizeForgetfulHashSet(int size, int initialCapacity) {
        this.map = new FixedsizeForgetfulHashMap(size, initialCapacity);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public FixedsizeForgetfulHashSet<E> clone() {
        try {
            FixedsizeForgetfulHashSet newSet = (FixedsizeForgetfulHashSet)super.clone();
            newSet.map = this.map.clone();
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

