/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.tsv;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.AbstractWriter;
import org.junit.jupiter.params.shadow.com.univocity.parsers.tsv.TsvFormat;
import org.junit.jupiter.params.shadow.com.univocity.parsers.tsv.TsvWriterSettings;

public class TsvWriter
extends AbstractWriter<TsvWriterSettings> {
    private boolean joinLines;
    private char escapeChar;
    private char escapedTabChar;
    private char newLine;

    public TsvWriter(TsvWriterSettings settings2) {
        this((Writer)null, settings2);
    }

    public TsvWriter(Writer writer, TsvWriterSettings settings2) {
        super(writer, settings2);
    }

    public TsvWriter(File file, TsvWriterSettings settings2) {
        super(file, settings2);
    }

    public TsvWriter(File file, String encoding, TsvWriterSettings settings2) {
        super(file, encoding, settings2);
    }

    public TsvWriter(File file, Charset encoding, TsvWriterSettings settings2) {
        super(file, encoding, settings2);
    }

    public TsvWriter(OutputStream output, TsvWriterSettings settings2) {
        super(output, settings2);
    }

    public TsvWriter(OutputStream output, String encoding, TsvWriterSettings settings2) {
        super(output, encoding, settings2);
    }

    public TsvWriter(OutputStream output, Charset encoding, TsvWriterSettings settings2) {
        super(output, encoding, settings2);
    }

    @Override
    protected final void initialize(TsvWriterSettings settings2) {
        this.escapeChar = ((TsvFormat)settings2.getFormat()).getEscapeChar();
        this.escapedTabChar = ((TsvFormat)settings2.getFormat()).getEscapedTabChar();
        this.joinLines = settings2.isLineJoiningEnabled();
        this.newLine = ((TsvFormat)settings2.getFormat()).getNormalizedNewline();
    }

    @Override
    protected void processRow(Object[] row) {
        for (int i2 = 0; i2 < row.length; ++i2) {
            if (i2 != 0) {
                this.appendToRow('\t');
            }
            String nextElement = this.getStringValue(row[i2]);
            boolean allowTrim = this.allowTrim(i2);
            int originalLength = this.appender.length();
            this.append(nextElement, allowTrim);
            if (this.appender.length() == originalLength && this.nullValue != null && !this.nullValue.isEmpty()) {
                this.append(this.nullValue, allowTrim);
            }
            this.appendValueToRow();
        }
    }

    private void append(String element, boolean allowTrim) {
        int i2;
        if (element == null) {
            element = this.nullValue;
        }
        if (element == null) {
            return;
        }
        int start = 0;
        if (allowTrim && this.ignoreLeading) {
            start = TsvWriter.skipLeadingWhitespace(this.whitespaceRangeStart, element);
        }
        int length = element.length();
        char ch = '\u0000';
        for (i2 = start; i2 < length; ++i2) {
            ch = element.charAt(i2);
            if (ch != '\t' && ch != '\n' && ch != '\r' && ch != '\\') continue;
            this.appender.append(element, start, i2);
            start = i2 + 1;
            this.appender.append(this.escapeChar);
            if (ch == '\t') {
                this.appender.append(this.escapedTabChar);
                continue;
            }
            if (ch == '\n') {
                this.appender.append(this.joinLines ? (char)this.newLine : (char)'n');
                continue;
            }
            if (ch == '\\') {
                this.appender.append('\\');
                continue;
            }
            this.appender.append(this.joinLines ? (char)this.newLine : (char)'r');
        }
        this.appender.append(element, start, i2);
        if (allowTrim && ch <= ' ' && this.ignoreTrailing && this.whitespaceRangeStart < ch) {
            this.appender.updateWhitespace();
        }
    }
}

