/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

class MethodArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<MethodSource> {
    private String[] methodNames;

    MethodArgumentsProvider() {
    }

    @Override
    public void accept(MethodSource annotation) {
        this.methodNames = annotation.value();
    }

    public Stream<Arguments> provideArguments(ExtensionContext context) {
        Object testInstance = context.getTestInstance().orElse(null);
        return Arrays.stream(this.methodNames).map(factoryMethodName -> this.getFactoryMethod(context, (String)factoryMethodName)).map(factoryMethod -> context.getExecutableInvoker().invoke((Method)factoryMethod, (Object)testInstance)).flatMap(CollectionUtils::toStream).map(MethodArgumentsProvider::toArguments);
    }

    private Method getFactoryMethod(ExtensionContext context, String factoryMethodName) {
        Method testMethod = context.getRequiredTestMethod();
        if (StringUtils.isBlank(factoryMethodName)) {
            factoryMethodName = testMethod.getName();
        }
        if (factoryMethodName.contains(".") || factoryMethodName.contains("#")) {
            return this.getFactoryMethodByFullyQualifiedName(factoryMethodName);
        }
        return this.getFactoryMethodBySimpleName(context.getRequiredTestClass(), testMethod, factoryMethodName);
    }

    private Method getFactoryMethodByFullyQualifiedName(String fullyQualifiedMethodName) {
        String[] methodParts = ReflectionUtils.parseFullyQualifiedMethodName(fullyQualifiedMethodName);
        String className = methodParts[0];
        String methodName = methodParts[1];
        String methodParameters = methodParts[2];
        return ReflectionUtils.findMethod(this.loadRequiredClass(className), methodName, methodParameters).orElseThrow(() -> new JUnitException(String.format("Could not find factory method [%s(%s)] in class [%s]", methodName, methodParameters, className)));
    }

    private Method getFactoryMethodBySimpleName(Class<?> testClass, Method testMethod, String factoryMethodName) {
        List<Method> methods = ReflectionUtils.findMethods(testClass, factoryMethod -> factoryMethodName.equals(factoryMethod.getName()) && !testMethod.equals(factoryMethod));
        Preconditions.condition(methods.size() > 0, () -> String.format("Could not find factory method [%s] in class [%s]", factoryMethodName, testClass.getName()));
        Preconditions.condition(methods.size() == 1, () -> String.format("Several factory methods named [%s] were found in class [%s]", factoryMethodName, testClass.getName()));
        return methods.get(0);
    }

    private Class<?> loadRequiredClass(String className) {
        return ReflectionUtils.tryToLoadClass(className).getOrThrow(cause -> new JUnitException(String.format("Could not load class [%s]", className), (Throwable)cause));
    }

    private static Arguments toArguments(Object item) {
        if (item instanceof Arguments) {
            return (Arguments)item;
        }
        if (ReflectionUtils.isMultidimensionalArray(item)) {
            return Arguments.arguments(item);
        }
        if (item instanceof Object[]) {
            return Arguments.arguments((Object[])item);
        }
        return Arguments.arguments(item);
    }
}

