/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.engine.extension.TimeoutDuration;
import org.junit.jupiter.engine.extension.TimeoutExceptionFactory;
import org.opentest4j.AssertionFailedError;

class SeparateThreadTimeoutInvocation<T>
implements InvocationInterceptor.Invocation<T> {
    private final InvocationInterceptor.Invocation<T> delegate;
    private final TimeoutDuration timeout;
    private final Supplier<String> descriptionSupplier;

    SeparateThreadTimeoutInvocation(InvocationInterceptor.Invocation<T> delegate, TimeoutDuration timeout2, Supplier<String> descriptionSupplier) {
        this.delegate = delegate;
        this.timeout = timeout2;
        this.descriptionSupplier = descriptionSupplier;
    }

    @Override
    public T proceed() throws Throwable {
        try {
            return (T)Assertions.assertTimeoutPreemptively(this.timeout.toDuration(), this.delegate::proceed, this.descriptionSupplier);
        }
        catch (AssertionFailedError failure) {
            TimeoutException exception = TimeoutExceptionFactory.create(this.descriptionSupplier.get(), this.timeout, null);
            exception.initCause(failure.getCause());
            throw exception;
        }
    }
}

