/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.vorbiscomment;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentFieldKey;

public class VorbisCommentTagField
implements TagTextField {
    private boolean common;
    private String content;
    private String id;
    private static final String ERRONEOUS_ID = "ERRONEOUS";

    public VorbisCommentTagField(byte[] raw) throws UnsupportedEncodingException {
        String field = new String(raw, "UTF-8");
        int i2 = field.indexOf("=");
        if (i2 == -1) {
            this.id = ERRONEOUS_ID;
            this.content = field;
        } else {
            this.id = field.substring(0, i2).toUpperCase();
            this.content = field.length() > i2 ? field.substring(i2 + 1) : "";
        }
        this.checkCommon();
    }

    public VorbisCommentTagField(String fieldId, String fieldContent) {
        this.id = fieldId.toUpperCase();
        this.content = fieldContent;
        this.checkCommon();
    }

    private void checkCommon() {
        this.common = this.id.equals(VorbisCommentFieldKey.TITLE.getFieldName()) || this.id.equals(VorbisCommentFieldKey.ALBUM.getFieldName()) || this.id.equals(VorbisCommentFieldKey.ARTIST.getFieldName()) || this.id.equals(VorbisCommentFieldKey.GENRE.getFieldName()) || this.id.equals(VorbisCommentFieldKey.TRACKNUMBER.getFieldName()) || this.id.equals(VorbisCommentFieldKey.DATE.getFieldName()) || this.id.equals(VorbisCommentFieldKey.DESCRIPTION.getFieldName()) || this.id.equals(VorbisCommentFieldKey.COMMENT.getFieldName());
    }

    protected void copy(byte[] src, byte[] dst, int dstOffset) {
        System.arraycopy(src, 0, dst, dstOffset, src.length);
    }

    @Override
    public void copyContent(TagField field) {
        if (field instanceof TagTextField) {
            this.content = ((TagTextField)field).getContent();
        }
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public Charset getEncoding() {
        return StandardCharsets.UTF_8;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public byte[] getRawContent() throws UnsupportedEncodingException {
        byte[] size = new byte[4];
        byte[] idBytes = this.id.getBytes(StandardCharsets.ISO_8859_1);
        byte[] contentBytes = this.content.getBytes(StandardCharsets.UTF_8);
        byte[] b = new byte[4 + idBytes.length + 1 + contentBytes.length];
        int length = idBytes.length + 1 + contentBytes.length;
        size[3] = (byte)((length & 0xFF000000) >> 24);
        size[2] = (byte)((length & 0xFF0000) >> 16);
        size[1] = (byte)((length & 0xFF00) >> 8);
        size[0] = (byte)(length & 0xFF);
        int offset = 0;
        this.copy(size, b, offset);
        this.copy(idBytes, b, offset += 4);
        b[offset += idBytes.length] = 61;
        this.copy(contentBytes, b, ++offset);
        return b;
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public void isBinary(boolean b) {
        if (b) {
            throw new UnsupportedOperationException("OggTagFields cannot be changed to binary.\nbinary data should be stored elsewhere according to Vorbis_I_spec.");
        }
    }

    @Override
    public boolean isCommon() {
        return this.common;
    }

    @Override
    public boolean isEmpty() {
        return this.content.equals("");
    }

    @Override
    public void setContent(String s) {
        this.content = s;
    }

    @Override
    public void setEncoding(Charset s) {
        if (!StandardCharsets.UTF_8.equals(s)) {
            throw new UnsupportedOperationException("The encoding of OggTagFields cannot be changed.(specified to be UTF-8)");
        }
    }

    @Override
    public String toString() {
        return this.getContent();
    }
}

