/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;
import org.jaudiotagger.tag.options.PadNumberOption;
import org.jaudiotagger.utils.EqualsUtil;

public class PartOfSet
extends AbstractString {
    public PartOfSet(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
    }

    public PartOfSet(PartOfSet object) {
        super(object);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PartOfSet)) {
            return false;
        }
        PartOfSet that = (PartOfSet)obj;
        return EqualsUtil.areEqual(this.value, that.value);
    }

    @Override
    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        CharsetDecoder decoder = this.getTextEncodingCharSet().newDecoder();
        ByteBuffer inBuffer = ByteBuffer.wrap(arr, offset, arr.length - offset).slice();
        CharBuffer outBuffer = CharBuffer.allocate(arr.length - offset);
        decoder.reset();
        CoderResult coderResult = decoder.decode(inBuffer, outBuffer, true);
        if (coderResult.isError()) {
            logger.warning("Decoding error:" + coderResult.toString());
        }
        decoder.flush(outBuffer);
        outBuffer.flip();
        String stringValue = outBuffer.toString();
        this.value = new PartOfSetValue(stringValue);
        this.setSize(arr.length - offset);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Read SizeTerminatedString:" + this.value + " size:" + this.size);
        }
    }

    @Override
    public byte[] writeByteArray() {
        byte[] data;
        String value = this.getValue().toString();
        try {
            String valueWithBOM;
            CharsetEncoder encoder;
            Charset charset;
            if (TagOptionSingleton.getInstance().isRemoveTrailingTerminatorOnWrite() && value.length() > 0 && value.charAt(value.length() - 1) == '\u0000') {
                value = value.substring(0, value.length() - 1);
            }
            if (StandardCharsets.UTF_16.equals(charset = this.getTextEncodingCharSet())) {
                encoder = StandardCharsets.UTF_16LE.newEncoder();
                valueWithBOM = '\ufeff' + value;
            } else {
                encoder = charset.newEncoder();
                valueWithBOM = value;
            }
            encoder.onMalformedInput(CodingErrorAction.IGNORE);
            encoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
            ByteBuffer bb = encoder.encode(CharBuffer.wrap(valueWithBOM));
            data = new byte[bb.limit()];
            bb.get(data, 0, bb.limit());
        }
        catch (CharacterCodingException ce) {
            logger.severe(ce.getMessage());
            throw new RuntimeException(ce);
        }
        this.setSize(data.length);
        return data;
    }

    @Override
    protected Charset getTextEncodingCharSet() {
        byte textEncoding = this.getBody().getTextEncoding();
        Charset charset = TextEncoding.getInstanceOf().getCharsetForId(textEncoding);
        logger.finest("text encoding:" + textEncoding + " charset:" + charset.name());
        return charset;
    }

    @Override
    public PartOfSetValue getValue() {
        return (PartOfSetValue)this.value;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    public static class PartOfSetValue {
        private static final Pattern trackNoPatternWithTotalCount = Pattern.compile("([0-9]+)/([0-9]+)(.*)", 2);
        private static final Pattern trackNoPattern = Pattern.compile("([0-9]+)(.*)", 2);
        private static final String SEPARATOR = "/";
        private Integer count;
        private Integer total;
        private String extra;
        private String rawText;
        private String rawCount;
        private String rawTotal;

        public PartOfSetValue() {
            this.rawText = "";
        }

        public PartOfSetValue(String value) {
            this.rawText = value;
            this.initFromValue(value);
        }

        public PartOfSetValue(Integer count, Integer total) {
            this.count = count;
            this.rawCount = count.toString();
            this.total = total;
            this.rawTotal = total.toString();
            this.resetValueFromCounts();
        }

        private void initFromValue(String value) {
            try {
                Matcher m = trackNoPatternWithTotalCount.matcher(value);
                if (m.matches()) {
                    this.extra = m.group(3);
                    this.count = Integer.parseInt(m.group(1));
                    this.rawCount = m.group(1);
                    this.total = Integer.parseInt(m.group(2));
                    this.rawTotal = m.group(2);
                    return;
                }
                m = trackNoPattern.matcher(value);
                if (m.matches()) {
                    this.extra = m.group(2);
                    this.count = Integer.parseInt(m.group(1));
                    this.rawCount = m.group(1);
                }
            }
            catch (NumberFormatException nfe) {
                this.count = 0;
            }
        }

        private void resetValueFromCounts() {
            StringBuffer sb = new StringBuffer();
            if (this.rawCount != null) {
                sb.append(this.rawCount);
            } else {
                sb.append("0");
            }
            if (this.rawTotal != null) {
                sb.append(SEPARATOR + this.rawTotal);
            }
            if (this.extra != null) {
                sb.append(this.extra);
            }
            this.rawText = sb.toString();
        }

        public Integer getCount() {
            return this.count;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setCount(Integer count) {
            this.count = count;
            this.rawCount = count.toString();
            this.resetValueFromCounts();
        }

        public void setTotal(Integer total) {
            this.total = total;
            this.rawTotal = total.toString();
            this.resetValueFromCounts();
        }

        public void setCount(String count) {
            try {
                this.count = Integer.parseInt(count);
                this.rawCount = count;
                this.resetValueFromCounts();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void setTotal(String total) {
            try {
                this.total = Integer.parseInt(total);
                this.rawTotal = total;
                this.resetValueFromCounts();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public String getRawValue() {
            return this.rawText;
        }

        public void setRawValue(String value) {
            this.rawText = value;
            this.initFromValue(value);
        }

        public String getCountAsText() {
            StringBuffer sb = new StringBuffer();
            if (!TagOptionSingleton.getInstance().isPadNumbers()) {
                return this.rawCount;
            }
            this.padNumber(sb, this.count, TagOptionSingleton.getInstance().getPadNumberTotalLength());
            return sb.toString();
        }

        private void padNumber(StringBuffer sb, Integer count, PadNumberOption padNumberLength) {
            if (count != null) {
                if (padNumberLength == PadNumberOption.PAD_ONE_ZERO) {
                    if (count > 0 && count < 10) {
                        sb.append("0").append(count);
                    } else {
                        sb.append(count);
                    }
                } else if (padNumberLength == PadNumberOption.PAD_TWO_ZERO) {
                    if (count > 0 && count < 10) {
                        sb.append("00").append(count);
                    } else if (count > 9 && count < 100) {
                        sb.append("0").append(count);
                    } else {
                        sb.append(count);
                    }
                } else if (padNumberLength == PadNumberOption.PAD_THREE_ZERO) {
                    if (count > 0 && count < 10) {
                        sb.append("000").append(count);
                    } else if (count > 9 && count < 100) {
                        sb.append("00").append(count);
                    } else if (count > 99 && count < 1000) {
                        sb.append("0").append(count);
                    } else {
                        sb.append(count);
                    }
                }
            }
        }

        public String getTotalAsText() {
            StringBuffer sb = new StringBuffer();
            if (!TagOptionSingleton.getInstance().isPadNumbers()) {
                return this.rawTotal;
            }
            this.padNumber(sb, this.total, TagOptionSingleton.getInstance().getPadNumberTotalLength());
            return sb.toString();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (!TagOptionSingleton.getInstance().isPadNumbers()) {
                return this.rawText;
            }
            if (this.count != null) {
                this.padNumber(sb, this.count, TagOptionSingleton.getInstance().getPadNumberTotalLength());
            } else if (this.total != null) {
                this.padNumber(sb, 0, TagOptionSingleton.getInstance().getPadNumberTotalLength());
            }
            if (this.total != null) {
                sb.append(SEPARATOR);
                this.padNumber(sb, this.total, TagOptionSingleton.getInstance().getPadNumberTotalLength());
            }
            if (this.extra != null) {
                sb.append(this.extra);
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PartOfSetValue)) {
                return false;
            }
            PartOfSetValue that = (PartOfSetValue)obj;
            return EqualsUtil.areEqual(this.getCount(), that.getCount()) && EqualsUtil.areEqual(this.getTotal(), that.getTotal());
        }
    }
}

