/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg.util;

import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.jaudiotagger.audio.ogg.VorbisVersion;
import org.jaudiotagger.audio.ogg.util.VorbisHeader;
import org.jaudiotagger.audio.ogg.util.VorbisPacketType;

public class VorbisIdentificationHeader
implements VorbisHeader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.ogg.atom");
    private int audioChannels;
    private boolean isValid = false;
    private int vorbisVersion;
    private int audioSampleRate;
    private int bitrateMinimal;
    private int bitrateNominal;
    private int bitrateMaximal;
    public static final int FIELD_VORBIS_VERSION_POS = 7;
    public static final int FIELD_AUDIO_CHANNELS_POS = 11;
    public static final int FIELD_AUDIO_SAMPLE_RATE_POS = 12;
    public static final int FIELD_BITRATE_MAX_POS = 16;
    public static final int FIELD_BITRATE_NOMAIML_POS = 20;
    public static final int FIELD_BITRATE_MIN_POS = 24;
    public static final int FIELD_BLOCKSIZE_POS = 28;
    public static final int FIELD_FRAMING_FLAG_POS = 29;
    public static final int FIELD_VORBIS_VERSION_LENGTH = 4;
    public static final int FIELD_AUDIO_CHANNELS_LENGTH = 1;
    public static final int FIELD_AUDIO_SAMPLE_RATE_LENGTH = 4;
    public static final int FIELD_BITRATE_MAX_LENGTH = 4;
    public static final int FIELD_BITRATE_NOMAIML_LENGTH = 4;
    public static final int FIELD_BITRATE_MIN_LENGTH = 4;
    public static final int FIELD_BLOCKSIZE_LENGTH = 1;
    public static final int FIELD_FRAMING_FLAG_LENGTH = 1;

    public VorbisIdentificationHeader(byte[] vorbisData) {
        this.decodeHeader(vorbisData);
    }

    public int getChannelNumber() {
        return this.audioChannels;
    }

    public String getEncodingType() {
        return VorbisVersion.values()[this.vorbisVersion].toString();
    }

    public int getSamplingRate() {
        return this.audioSampleRate;
    }

    public int getNominalBitrate() {
        return this.bitrateNominal;
    }

    public int getMaxBitrate() {
        return this.bitrateMaximal;
    }

    public int getMinBitrate() {
        return this.bitrateMinimal;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void decodeHeader(byte[] b) {
        byte packetType = b[0];
        logger.fine("packetType" + packetType);
        String vorbis = new String(b, 1, 6, StandardCharsets.ISO_8859_1);
        if (packetType == VorbisPacketType.IDENTIFICATION_HEADER.getType() && vorbis.equals("vorbis")) {
            this.vorbisVersion = b[7] + (b[8] << 8) + (b[9] << 16) + (b[10] << 24);
            logger.fine("vorbisVersion" + this.vorbisVersion);
            this.audioChannels = this.u(b[11]);
            logger.fine("audioChannels" + this.audioChannels);
            this.audioSampleRate = this.u(b[12]) + (this.u(b[13]) << 8) + (this.u(b[14]) << 16) + (this.u(b[15]) << 24);
            logger.fine("audioSampleRate" + this.audioSampleRate);
            logger.fine("audioSampleRate" + b[12] + " " + b[13] + " " + b[14]);
            this.bitrateMinimal = this.u(b[16]) + (this.u(b[17]) << 8) + (this.u(b[18]) << 16) + (this.u(b[19]) << 24);
            this.bitrateNominal = this.u(b[20]) + (this.u(b[21]) << 8) + (this.u(b[22]) << 16) + (this.u(b[23]) << 24);
            this.bitrateMaximal = this.u(b[24]) + (this.u(b[25]) << 8) + (this.u(b[26]) << 16) + (this.u(b[27]) << 24);
            byte framingFlag = b[29];
            logger.fine("framingFlag" + framingFlag);
            if (framingFlag != 0) {
                this.isValid = true;
            }
        }
    }

    private int u(int i2) {
        return i2 & 0xFF;
    }
}

