/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;

public class OggPageHeader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.ogg.atom");
    public static final byte[] CAPTURE_PATTERN = new byte[]{79, 103, 103, 83};
    public static final int OGG_PAGE_HEADER_FIXED_LENGTH = 27;
    public static final int MAXIMUM_NO_OF_SEGMENT_SIZE = 255;
    public static final int MAXIMUM_SEGMENT_SIZE = 255;
    public static final int MAXIMUM_PAGE_HEADER_SIZE = 282;
    public static final int MAXIMUM_PAGE_DATA_SIZE = 65025;
    public static final int MAXIMUM_PAGE_SIZE = 65307;
    public static final int FIELD_CAPTURE_PATTERN_POS = 0;
    public static final int FIELD_STREAM_STRUCTURE_VERSION_POS = 4;
    public static final int FIELD_HEADER_TYPE_FLAG_POS = 5;
    public static final int FIELD_ABSOLUTE_GRANULE_POS = 6;
    public static final int FIELD_STREAM_SERIAL_NO_POS = 14;
    public static final int FIELD_PAGE_SEQUENCE_NO_POS = 18;
    public static final int FIELD_PAGE_CHECKSUM_POS = 22;
    public static final int FIELD_PAGE_SEGMENTS_POS = 26;
    public static final int FIELD_SEGMENT_TABLE_POS = 27;
    public static final int FIELD_CAPTURE_PATTERN_LENGTH = 4;
    public static final int FIELD_STREAM_STRUCTURE_VERSION_LENGTH = 1;
    public static final int FIELD_HEADER_TYPE_FLAG_LENGTH = 1;
    public static final int FIELD_ABSOLUTE_GRANULE_LENGTH = 8;
    public static final int FIELD_STREAM_SERIAL_NO_LENGTH = 4;
    public static final int FIELD_PAGE_SEQUENCE_NO_LENGTH = 4;
    public static final int FIELD_PAGE_CHECKSUM_LENGTH = 4;
    public static final int FIELD_PAGE_SEGMENTS_LENGTH = 1;
    private byte[] rawHeaderData;
    private double absoluteGranulePosition;
    private int checksum;
    private byte headerTypeFlag;
    private boolean isValid = false;
    private int pageLength = 0;
    private int pageSequenceNumber;
    private int streamSerialNumber;
    private byte[] segmentTable;
    private List<PacketStartAndLength> packetList = new ArrayList<PacketStartAndLength>();
    private boolean lastPacketIncomplete = false;
    private long startByte = 0L;

    public static OggPageHeader read(ByteBuffer byteBuffer) throws IOException, CannotReadException {
        int start = byteBuffer.position();
        logger.fine("Trying to read OggPage at:" + start);
        byte[] b = new byte[CAPTURE_PATTERN.length];
        byteBuffer.get(b);
        if (!Arrays.equals(b, CAPTURE_PATTERN)) {
            throw new CannotReadException(ErrorMessage.OGG_HEADER_CANNOT_BE_FOUND.getMsg(new String(b)));
        }
        byteBuffer.position(start + 26);
        int pageSegments = byteBuffer.get() & 0xFF;
        byteBuffer.position(start);
        b = new byte[27 + pageSegments];
        byteBuffer.get(b);
        OggPageHeader pageHeader = new OggPageHeader(b);
        return pageHeader;
    }

    public static OggPageHeader read(RandomAccessFile raf) throws IOException, CannotReadException {
        long start = raf.getFilePointer();
        logger.fine("Trying to read OggPage at:" + start);
        byte[] b = new byte[CAPTURE_PATTERN.length];
        raf.read(b);
        if (!Arrays.equals(b, CAPTURE_PATTERN)) {
            raf.seek(start);
            if (AbstractID3v2Tag.isId3Tag(raf)) {
                logger.warning(ErrorMessage.OGG_CONTAINS_ID3TAG.getMsg(raf.getFilePointer() - start));
                raf.read(b);
                if (Arrays.equals(b, CAPTURE_PATTERN)) {
                    start = raf.getFilePointer() - (long)CAPTURE_PATTERN.length;
                }
            } else {
                throw new CannotReadException(ErrorMessage.OGG_HEADER_CANNOT_BE_FOUND.getMsg(new String(b)));
            }
        }
        raf.seek(start + 26L);
        int pageSegments = raf.readByte() & 0xFF;
        raf.seek(start);
        b = new byte[27 + pageSegments];
        raf.read(b);
        OggPageHeader pageHeader = new OggPageHeader(b);
        pageHeader.setStartByte(start);
        return pageHeader;
    }

    public OggPageHeader(byte[] b) {
        this.rawHeaderData = b;
        byte streamStructureRevision = b[4];
        this.headerTypeFlag = b[5];
        if (streamStructureRevision == 0) {
            this.absoluteGranulePosition = 0.0;
            for (int i2 = 0; i2 < 8; ++i2) {
                this.absoluteGranulePosition += (double)this.u(b[i2 + 6]) * Math.pow(2.0, 8 * i2);
            }
            this.streamSerialNumber = Utils.getIntLE(b, 14, 17);
            this.pageSequenceNumber = Utils.getIntLE(b, 18, 21);
            this.checksum = Utils.getIntLE(b, 22, 25);
            int pageSegments = this.u(b[26]);
            this.segmentTable = new byte[b.length - 27];
            int packetLength = 0;
            Integer segmentLength = null;
            for (int i3 = 0; i3 < this.segmentTable.length; ++i3) {
                this.segmentTable[i3] = b[27 + i3];
                segmentLength = this.u(this.segmentTable[i3]);
                this.pageLength += segmentLength.intValue();
                packetLength += segmentLength.intValue();
                if (segmentLength >= 255) continue;
                this.packetList.add(new PacketStartAndLength(this.pageLength - packetLength, packetLength));
                packetLength = 0;
            }
            if (segmentLength != null && segmentLength == 255) {
                this.packetList.add(new PacketStartAndLength(this.pageLength - packetLength, packetLength));
                this.lastPacketIncomplete = true;
            }
            this.isValid = true;
        }
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Constructed OggPage:" + this.toString());
        }
    }

    private int u(int i2) {
        return i2 & 0xFF;
    }

    public boolean isLastPacketIncomplete() {
        return this.lastPacketIncomplete;
    }

    public double getAbsoluteGranulePosition() {
        logger.fine("Number Of Samples: " + this.absoluteGranulePosition);
        return this.absoluteGranulePosition;
    }

    public int getCheckSum() {
        return this.checksum;
    }

    public byte getHeaderType() {
        return this.headerTypeFlag;
    }

    public int getPageLength() {
        logger.finer("This page length: " + this.pageLength);
        return this.pageLength;
    }

    public int getPageSequence() {
        return this.pageSequenceNumber;
    }

    public int getSerialNumber() {
        return this.streamSerialNumber;
    }

    public byte[] getSegmentTable() {
        return this.segmentTable;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public List<PacketStartAndLength> getPacketList() {
        return this.packetList;
    }

    public byte[] getRawHeaderData() {
        return this.rawHeaderData;
    }

    public String toString() {
        String out = "Ogg Page Header:isValid:" + this.isValid + ":type:" + this.headerTypeFlag + ":oggPageHeaderLength:" + this.rawHeaderData.length + ":length:" + this.pageLength + ":seqNo:" + this.getPageSequence() + ":packetIncomplete:" + this.isLastPacketIncomplete() + ":serNum:" + this.getSerialNumber();
        for (PacketStartAndLength packet : this.getPacketList()) {
            out = out + packet.toString();
        }
        return out;
    }

    public long getStartByte() {
        return this.startByte;
    }

    public void setStartByte(long startByte) {
        this.startByte = startByte;
    }

    public static enum HeaderTypeFlag {
        FRESH_PACKET(0),
        CONTINUED_PACKET(1),
        START_OF_BITSTREAM(2),
        END_OF_BITSTREAM(4);

        byte fileValue;

        private HeaderTypeFlag(byte fileValue) {
            this.fileValue = fileValue;
        }

        public byte getFileValue() {
            return this.fileValue;
        }
    }

    public static class PacketStartAndLength {
        private Integer startPosition = 0;
        private Integer length = 0;

        public PacketStartAndLength(int startPosition, int length) {
            this.startPosition = startPosition;
            this.length = length;
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public void setStartPosition(int startPosition) {
            this.startPosition = startPosition;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public String toString() {
            return "NextPkt(start:" + this.startPosition + ":length:" + this.length + "),";
        }
    }
}

