/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.util;

import java.util.Iterator;
import java.util.List;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.ContainerType;
import org.jaudiotagger.audio.asf.data.MetadataContainer;
import org.jaudiotagger.audio.asf.data.MetadataContainerFactory;
import org.jaudiotagger.audio.asf.data.MetadataDescriptor;
import org.jaudiotagger.audio.asf.util.Utils;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.asf.AsfFieldKey;
import org.jaudiotagger.tag.asf.AsfTag;
import org.jaudiotagger.tag.asf.AsfTagBannerField;
import org.jaudiotagger.tag.asf.AsfTagCoverField;
import org.jaudiotagger.tag.asf.AsfTagField;
import org.jaudiotagger.tag.asf.AsfTagTextField;
import org.jaudiotagger.tag.reference.GenreTypes;

public final class TagConverter {
    public static void assignCommonTagValues(Tag tag, MetadataContainer description) {
        MetadataDescriptor tmp;
        assert (description.getContainerType() == ContainerType.EXTENDED_CONTENT);
        if (!Utils.isBlank(tag.getFirst(FieldKey.ALBUM))) {
            tmp = new MetadataDescriptor(description.getContainerType(), AsfFieldKey.ALBUM.getFieldName(), 0);
            tmp.setStringValue(tag.getFirst(FieldKey.ALBUM));
            description.removeDescriptorsByName(tmp.getName());
            description.addDescriptor(tmp);
        } else {
            description.removeDescriptorsByName(AsfFieldKey.ALBUM.getFieldName());
        }
        if (!Utils.isBlank(tag.getFirst(FieldKey.TRACK))) {
            tmp = new MetadataDescriptor(description.getContainerType(), AsfFieldKey.TRACK.getFieldName(), 0);
            tmp.setStringValue(tag.getFirst(FieldKey.TRACK));
            description.removeDescriptorsByName(tmp.getName());
            description.addDescriptor(tmp);
        } else {
            description.removeDescriptorsByName(AsfFieldKey.TRACK.getFieldName());
        }
        if (!Utils.isBlank(tag.getFirst(FieldKey.YEAR))) {
            tmp = new MetadataDescriptor(description.getContainerType(), AsfFieldKey.YEAR.getFieldName(), 0);
            tmp.setStringValue(tag.getFirst(FieldKey.YEAR));
            description.removeDescriptorsByName(tmp.getName());
            description.addDescriptor(tmp);
        } else {
            description.removeDescriptorsByName(AsfFieldKey.YEAR.getFieldName());
        }
        if (!Utils.isBlank(tag.getFirst(FieldKey.GENRE))) {
            tmp = new MetadataDescriptor(description.getContainerType(), AsfFieldKey.GENRE.getFieldName(), 0);
            tmp.setStringValue(tag.getFirst(FieldKey.GENRE));
            description.removeDescriptorsByName(tmp.getName());
            description.addDescriptor(tmp);
            Integer genreNum = GenreTypes.getInstanceOf().getIdForName(tag.getFirst(FieldKey.GENRE));
            if (genreNum != null) {
                tmp = new MetadataDescriptor(description.getContainerType(), AsfFieldKey.GENRE_ID.getFieldName(), 0);
                tmp.setStringValue("(" + genreNum + ")");
                description.removeDescriptorsByName(tmp.getName());
                description.addDescriptor(tmp);
            } else {
                description.removeDescriptorsByName(AsfFieldKey.GENRE_ID.getFieldName());
            }
        } else {
            description.removeDescriptorsByName(AsfFieldKey.GENRE.getFieldName());
            description.removeDescriptorsByName(AsfFieldKey.GENRE_ID.getFieldName());
        }
    }

    public static AsfTag createTagOf(AsfHeader source2) {
        AsfTag result = new AsfTag(true);
        for (int i2 = 0; i2 < ContainerType.values().length; ++i2) {
            MetadataContainer current = source2.findMetadataContainer(ContainerType.values()[i2]);
            if (current == null) continue;
            List<MetadataDescriptor> descriptors = current.getDescriptors();
            for (MetadataDescriptor descriptor : descriptors) {
                AsfTagField toAdd = descriptor.getType() == 1 ? (descriptor.getName().equals(AsfFieldKey.COVER_ART.getFieldName()) ? new AsfTagCoverField(descriptor) : (descriptor.getName().equals(AsfFieldKey.BANNER_IMAGE.getFieldName()) ? new AsfTagBannerField(descriptor) : new AsfTagField(descriptor))) : new AsfTagTextField(descriptor);
                result.addField(toAdd);
            }
        }
        return result;
    }

    public static MetadataContainer[] distributeMetadata(AsfTag tag) {
        Iterator<AsfTagField> asfFields = tag.getAsfFields();
        MetadataContainer[] createContainers = MetadataContainerFactory.getInstance().createContainers(ContainerType.getOrdered());
        while (asfFields.hasNext()) {
            AsfTagField current = asfFields.next();
            boolean assigned = false;
            for (int i2 = 0; !assigned && i2 < createContainers.length; ++i2) {
                if (!ContainerType.areInCorrectOrder(createContainers[i2].getContainerType(), AsfFieldKey.getAsfFieldKey(current.getId()).getHighestContainer()) || !createContainers[i2].isAddSupported(current.getDescriptor())) continue;
                createContainers[i2].addDescriptor(current.getDescriptor());
                assigned = true;
            }
            assert (assigned);
        }
        return createContainers;
    }

    private TagConverter() {
    }
}

