/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.StreamBitratePropertiesChunk;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

public class StreamBitratePropertiesReader
implements ChunkReader {
    private static final GUID[] APPLYING = new GUID[]{GUID.GUID_STREAM_BITRATE_PROPERTIES};

    protected StreamBitratePropertiesReader() {
    }

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    public GUID[] getApplyingIds() {
        return (GUID[])APPLYING.clone();
    }

    @Override
    public Chunk read(GUID guid, InputStream stream, long chunkStart) throws IOException {
        BigInteger chunkLen = Utils.readBig64(stream);
        StreamBitratePropertiesChunk result = new StreamBitratePropertiesChunk(chunkLen);
        long recordCount = Utils.readUINT16(stream);
        int i2 = 0;
        while ((long)i2 < recordCount) {
            int flags = Utils.readUINT16(stream);
            long avgBitrate = Utils.readUINT32(stream);
            result.addBitrateRecord(flags & 0xFF, avgBitrate);
            ++i2;
        }
        result.setPosition(chunkStart);
        return result;
    }
}

