/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;

public class StreamBitratePropertiesChunk
extends Chunk {
    private final List<Long> bitRates = new ArrayList<Long>();
    private final List<Integer> streamNumbers = new ArrayList<Integer>();

    public StreamBitratePropertiesChunk(BigInteger chunkLen) {
        super(GUID.GUID_STREAM_BITRATE_PROPERTIES, chunkLen);
    }

    public void addBitrateRecord(int streamNum, long averageBitrate) {
        this.streamNumbers.add(streamNum);
        this.bitRates.add(averageBitrate);
    }

    public long getAvgBitrate(int streamNumber) {
        Integer seach = streamNumber;
        int index = this.streamNumbers.indexOf(seach);
        long result = index == -1 ? -1L : this.bitRates.get(index);
        return result;
    }

    @Override
    public String prettyPrint(String prefix) {
        StringBuilder result = new StringBuilder(super.prettyPrint(prefix));
        for (int i2 = 0; i2 < this.bitRates.size(); ++i2) {
            result.append(prefix).append("  |-> Stream no. \"").append(this.streamNumbers.get(i2)).append("\" has an average bitrate of \"").append(this.bitRates.get(i2)).append('\"').append(Utils.LINE_SEPARATOR);
        }
        return result.toString();
    }
}

