/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPoolTask;
import org.gudy.azureus2.core3.util.TimerEvent;

public class ThreadPool {
    private static final boolean NAME_THREADS = false;
    private static final boolean LOG_WARNINGS = false;
    private static final int WARN_TIME = 10000;
    private static final List busy_pools = new ArrayList();
    private static final ThreadLocal tls = ThreadLocal.withInitial(() -> null);
    private static boolean busy_pool_timer_set = false;
    private final String name;
    private final List busy;
    private final boolean queue_when_full;
    private final List task_queue = new ArrayList();
    private final AESemaphore thread_sem;
    private final Average task_average = Average.getInstance(10000, 120);
    private int thread_name_index = 1;
    private int reserved_actual;
    private boolean warn_when_full;
    private long task_total;
    private long task_total_last;

    public ThreadPool(String _name, int _max_size) {
        this(_name, _max_size, false);
    }

    private ThreadPool(String _name, int _max_size, boolean _queue_when_full) {
        this.name = _name;
        this.queue_when_full = _queue_when_full;
        this.thread_sem = new AESemaphore(_max_size);
        this.busy = new ArrayList(_max_size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkAllTimeouts() {
        ArrayList pools;
        List list = busy_pools;
        synchronized (list) {
            pools = new ArrayList(busy_pools);
        }
        for (Object pool : pools) {
            ((ThreadPool)pool).checkTimeouts();
        }
    }

    void setWarnWhenFull() {
        this.warn_when_full = true;
    }

    public void run(AERunnable runnable2) {
        this.run(runnable2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(AERunnable runnable2, boolean manualRelease) {
        if (manualRelease && !(runnable2 instanceof ThreadPoolTask)) {
            throw new IllegalArgumentException("manual release only allowed for ThreadPoolTasks");
        }
        if (manualRelease) {
            ((ThreadPoolTask)runnable2).setManualRelease();
        }
        if (!this.queue_when_full && !this.thread_sem.reserveIfAvailable()) {
            threadPoolWorker recursive_worker = (threadPoolWorker)tls.get();
            if (recursive_worker == null || recursive_worker.getOwner() != this) {
                this.checkWarning();
                this.thread_sem.reserve();
            } else {
                if (runnable2 instanceof ThreadPoolTask) {
                    ThreadPoolTask task = (ThreadPoolTask)runnable2;
                    this.runIt(runnable2);
                    task.join();
                } else {
                    this.runIt(runnable2);
                }
                return;
            }
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.task_queue.add(runnable2);
            if (this.queue_when_full && !this.thread_sem.reserveIfAvailable()) {
                this.checkWarning();
            }
        }
    }

    private void runIt(AERunnable runnable2) {
        runnable2.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkWarning() {
        if (this.warn_when_full) {
            StringBuilder task_names = new StringBuilder();
            try {
                ThreadPool threadPool = this;
                synchronized (threadPool) {
                    for (Object o : this.busy) {
                        threadPoolWorker x = (threadPoolWorker)o;
                        AERunnable r = x.runnable;
                        if (r == null) continue;
                        String name = r instanceof ThreadPoolTask ? ((ThreadPoolTask)r).getName() : r.getClass().getName();
                        task_names.append(task_names.length() == 0 ? "" : ",").append(name);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.out.println("Thread pool '" + this.getName() + "' is full (busy=" + String.valueOf(task_names) + ")");
            this.warn_when_full = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTimeouts() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            long diff = this.task_total - this.task_total_last;
            this.task_average.addValue(diff);
            this.task_total_last = this.task_total;
            long now = SystemTime.getMonotonousTime();
            for (Object o : this.busy) {
                threadPoolWorker x = (threadPoolWorker)o;
                long elapsed = now - x.run_start_time;
                if (elapsed <= 10000L * (long)(x.warn_count + 1)) continue;
                ++x.warn_count;
            }
        }
    }

    private String getName() {
        return this.name;
    }

    class threadPoolWorker
    extends AEThread2 {
        private final String worker_name;
        private volatile AERunnable runnable;
        private long run_start_time;
        private int warn_count;

        threadPoolWorker() {
            super(ThreadPool.this.name, true);
            ++ThreadPool.this.thread_name_index;
            int thread_priority = 5;
            this.setPriority(thread_priority);
            this.worker_name = this.getName();
            this.start();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        String getWorkerName() {
            return this.worker_name;
        }

        ThreadPool getOwner() {
            return ThreadPool.this;
        }

        private static /* synthetic */ void lambda$run$0(TimerEvent event) {
            ThreadPool.checkAllTimeouts();
        }
    }
}

