/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.gudy.azureus2.core3.util.Average;

public class SystemTime {
    static final long TIME_GRANULARITY_MILLIS = 25L;
    private static final int STEPS_PER_SECOND = 40;
    private static final boolean SOD_IT_LETS_USE_HPC = false;
    private static final List<TickConsumer> systemTimeConsumers = new ArrayList<TickConsumer>();
    private static final List<TickConsumer> monotoneTimeConsumers = new ArrayList<TickConsumer>();
    private static final SystemTimeProvider instance = new SteppedProvider();
    private static volatile List<ChangeListener> clock_change_list = new ArrayList<ChangeListener>();

    static long getCurrentTime() {
        return instance.getTime();
    }

    public static long getMonotonousTime() {
        return instance.getMonoTime();
    }

    static long getSteppedMonotonousTime() {
        return instance.getSteppedMonoTime();
    }

    public static long getOffsetTime(long offsetMS) {
        return instance.getTime() + offsetMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerClockChangeListener(ChangeListener c) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList<ChangeListener> new_list = new ArrayList<ChangeListener>(clock_change_list);
            new_list.add(c);
            clock_change_list = new_list;
        }
    }

    private static long getHighPrecisionCounter() {
        return System.nanoTime();
    }

    public static void main(String[] args2) {
        for (int i2 = 0; i2 < 1; ++i2) {
            new Thread(() -> {
                long cstart = SystemTime.getCurrentTime();
                long mstart = SystemTime.getMonotonousTime();
                System.out.println("alter system clock to see differences between monotonous and current time");
                long cLastRound = cstart;
                long mLastRound = mstart;
                while (true) {
                    long mnow = SystemTime.getMonotonousTime();
                    long cnow = SystemTime.getCurrentTime();
                    System.out.println("current: " + (cnow - cstart) + " monotonous:" + (mnow - mstart) + " delta current:" + (cnow - cLastRound) + " delta monotonous:" + (mnow - mLastRound));
                    cLastRound = cnow;
                    mLastRound = mnow;
                    try {
                        Thread.sleep(15L);
                    }
                    catch (Throwable throwable) {
                    }
                }
            }).start();
        }
    }

    static interface SystemTimeProvider {
        public long getTime();

        public long getMonoTime();

        public long getSteppedMonoTime();
    }

    private static class SteppedProvider
    implements SystemTimeProvider {
        private static final long HPC_START = SystemTime.getHighPrecisionCounter() / 1000000L;
        private final AtomicLong last_approximate_time = new AtomicLong();
        private volatile long stepped_time = 0L;
        private final Object stepped_time_lock = new Object();
        private volatile long currentTimeOffset = System.currentTimeMillis();
        private volatile int access_count;
        private final Object access_count_lock = new Object();
        private volatile int slice_access_count;
        private final Object slice_access_count_lock = new Object();
        private volatile int access_average_per_slice;
        private volatile int drift_adjusted_granularity;
        private volatile long stepped_mono_time;

        private SteppedProvider() {
            Thread updater = new Thread("SystemTime"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long adjustedTimeOffset = currentTimeOffset;
                    Average access_average = Average.getInstance(1000, 10);
                    Average drift_average = Average.getInstance(1000, 10);
                    long lastOffset = adjustedTimeOffset;
                    long lastSecond = -1000L;
                    int tick_count = 0;
                    while (true) {
                        long change;
                        long rawTime;
                        long newMonotoneTime;
                        long delta;
                        if ((delta = (newMonotoneTime = (rawTime = System.currentTimeMillis()) - adjustedTimeOffset) - stepped_time) < 0L || delta > 1000L) {
                            var16_11 = stepped_time_lock;
                            synchronized (var16_11) {
                                stepped_time += 25L;
                            }
                            adjustedTimeOffset = rawTime - stepped_time;
                        } else {
                            var16_11 = stepped_time_lock;
                            synchronized (var16_11) {
                                stepped_time = newMonotoneTime;
                            }
                        }
                        if (++tick_count == 40) {
                            change = adjustedTimeOffset - lastOffset;
                            if (change != 0L) {
                                for (ChangeListener changeListener2 : clock_change_list) {
                                    try {
                                        changeListener2.clockChangeDetected(rawTime, change);
                                    }
                                    catch (Throwable e) {
                                        e.printStackTrace();
                                    }
                                }
                                lastOffset = adjustedTimeOffset;
                                currentTimeOffset = adjustedTimeOffset;
                            }
                            long drift = stepped_time - lastSecond - 1000L;
                            lastSecond = stepped_time;
                            drift_average.addValue(drift);
                            drift_adjusted_granularity = (int)(25L + drift_average.getAverage() / 40L);
                            access_average.addValue(access_count);
                            access_average_per_slice = (int)(access_average.getAverage() / 40L);
                            access_count = 0;
                            tick_count = 0;
                        } else {
                            change = 0L;
                        }
                        slice_access_count = 0;
                        stepped_mono_time = stepped_time;
                        long adjustedTime = stepped_time + currentTimeOffset;
                        if (change != 0L) {
                            for (ChangeListener changeListener : clock_change_list) {
                                try {
                                    changeListener.clockChangeCompleted(adjustedTime, change);
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        List<TickConsumer> consumersRef = monotoneTimeConsumers;
                        for (TickConsumer cons : consumersRef) {
                            try {
                                cons.consume(stepped_time);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                        consumersRef = systemTimeConsumers;
                        for (TickConsumer cons : consumersRef) {
                            try {
                                cons.consume(adjustedTime);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                        try {
                            Thread.sleep(25L);
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            updater.setDaemon(true);
            updater.setPriority(10);
            updater.start();
        }

        @Override
        public long getTime() {
            return this.getMonoTime() + this.currentTimeOffset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getMonoTime() {
            long adjusted_time;
            long averageSliceStep = this.access_average_per_slice;
            if (averageSliceStep > 0L) {
                long sliceStep = (long)(this.drift_adjusted_granularity * this.slice_access_count) / averageSliceStep;
                if (sliceStep >= (long)this.drift_adjusted_granularity) {
                    sliceStep = this.drift_adjusted_granularity - 1;
                }
                adjusted_time = sliceStep + this.stepped_time;
            } else {
                adjusted_time = this.stepped_time;
            }
            Object sliceStep = this.access_count_lock;
            synchronized (sliceStep) {
                ++this.access_count;
            }
            sliceStep = this.slice_access_count_lock;
            synchronized (sliceStep) {
                ++this.slice_access_count;
            }
            long approxBuffered = this.last_approximate_time.get();
            if (adjusted_time < approxBuffered) {
                adjusted_time = approxBuffered;
            } else {
                this.last_approximate_time.compareAndSet(approxBuffered, adjusted_time);
            }
            return adjusted_time;
        }

        @Override
        public long getSteppedMonoTime() {
            return this.stepped_mono_time;
        }
    }

    public static interface ChangeListener {
        public void clockChangeDetected(long var1, long var3);

        public void clockChangeCompleted(long var1, long var3);
    }

    static interface TickConsumer {
        public void consume(long var1);
    }
}

