/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.text.NumberFormat;
import java.util.Arrays;

public class DisplayFormatters {
    private static final boolean ROUND_NO = true;
    private static final boolean TRUNCZEROS_NO = false;
    private static final boolean TRUNCZEROS_YES = true;
    private static final int UNIT_B = 0;
    private static final int UNIT_KB = 1;
    private static final int UNIT_MB = 2;
    private static final int UNIT_GB = 3;
    private static final int UNIT_TB = 4;
    private static final int[] UNITS_PRECISION = new int[]{0, 1, 2, 2, 3};
    private static final NumberFormat[] cached_number_formats = new NumberFormat[20];
    private static final int unitsStopAt = 4;
    private static String[] units;
    private static String[] units_rate;

    private static void setUnits() {
        units = new String[5];
        String[] units_bits = new String[5];
        units_rate = new String[5];
        switch (4) {
            case 4: {
                DisplayFormatters.units[4] = DisplayFormatters.getUnit("TB");
                units_bits[4] = DisplayFormatters.getUnit("Tbit");
                DisplayFormatters.units_rate[4] = DisplayFormatters.getUnit("TB");
            }
            case 3: {
                DisplayFormatters.units[3] = DisplayFormatters.getUnit("GB");
                units_bits[3] = DisplayFormatters.getUnit("Gbit");
                DisplayFormatters.units_rate[3] = DisplayFormatters.getUnit("GB");
            }
            case 2: {
                DisplayFormatters.units[2] = DisplayFormatters.getUnit("MB");
                units_bits[2] = DisplayFormatters.getUnit("Mbit");
                DisplayFormatters.units_rate[2] = DisplayFormatters.getUnit("MB");
            }
            case 1: {
                DisplayFormatters.units[1] = DisplayFormatters.getUnit("kB");
                units_bits[1] = DisplayFormatters.getUnit("kbit");
                DisplayFormatters.units_rate[1] = DisplayFormatters.getUnit("kB");
            }
            case 0: {
                DisplayFormatters.units[0] = DisplayFormatters.getUnit("B");
                units_bits[0] = DisplayFormatters.getUnit("bit");
                DisplayFormatters.units_rate[0] = DisplayFormatters.getUnit("B");
            }
        }
        String per_sec = "/s";
        for (int i2 = 0; i2 <= 4; ++i2) {
            DisplayFormatters.units[i2] = units[i2];
            DisplayFormatters.units_rate[i2] = units_rate[i2] + per_sec;
        }
        Arrays.fill(cached_number_formats, null);
        NumberFormat percentage_format = NumberFormat.getPercentInstance();
        percentage_format.setMinimumFractionDigits(1);
        percentage_format.setMaximumFractionDigits(1);
    }

    private static String getUnit(String key) {
        return " " + key;
    }

    private static String formatByteCountToKiBEtc(long n) {
        return DisplayFormatters.formatByteCountToKiBEtc(n, true, false, -1);
    }

    private static String formatByteCountToKiBEtc(long n, boolean rate, boolean bTruncateZeros, int precision) {
        int unitIndex;
        double dbl = n;
        long div = 1000L;
        for (unitIndex = 0; dbl >= (double)div && unitIndex < 4; dbl /= (double)div, ++unitIndex) {
        }
        if (precision < 0) {
            precision = UNITS_PRECISION[unitIndex];
        }
        return DisplayFormatters.formatDecimal(dbl, precision, bTruncateZeros, rate) + (rate ? units_rate[unitIndex] : units[unitIndex]);
    }

    public static String formatByteCountToKiBEtcPerSec(long n) {
        return DisplayFormatters.formatByteCountToKiBEtc(n);
    }

    private static String formatDecimal(double value, int precision) {
        return DisplayFormatters.formatDecimal(value, precision, false, true);
    }

    private static String formatDecimal(double value, int precision, boolean bTruncateZeros, boolean bRound) {
        double tValue;
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return "\u221e";
        }
        if (bRound) {
            tValue = value;
        } else if (precision == 0) {
            tValue = (long)value;
        } else {
            double shift = Math.pow(10.0, precision);
            tValue = (double)((long)(value * shift)) / shift;
        }
        int cache_index = (precision << 2) + ((bTruncateZeros ? 1 : 0) << 1) + (bRound ? 1 : 0);
        NumberFormat nf = null;
        if (cache_index < cached_number_formats.length) {
            nf = cached_number_formats[cache_index];
        }
        if (nf == null) {
            nf = NumberFormat.getNumberInstance();
            nf.setGroupingUsed(false);
            if (!bTruncateZeros) {
                nf.setMinimumFractionDigits(precision);
            }
            if (bRound) {
                nf.setMaximumFractionDigits(precision);
            }
            if (cache_index < cached_number_formats.length) {
                DisplayFormatters.cached_number_formats[cache_index] = nf;
            }
        }
        return nf.format(tValue);
    }

    public static void main(String[] args2) {
        double d = 3.991630774821635E-6;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(6);
        nf.setMinimumFractionDigits(6);
        String s = nf.format(d);
        System.out.println("Actual: " + d);
        System.out.println("NF/6:   " + s);
        System.out.println("DF:     " + DisplayFormatters.formatDecimal(d, 6));
        System.out.println("DF 0:   " + DisplayFormatters.formatDecimal(d, 0));
        System.out.println("0.000000:" + DisplayFormatters.formatDecimal(0.0, 6));
        System.out.println("0.001:" + DisplayFormatters.formatDecimal(0.001, 6, true, true));
        System.out.println("0:" + DisplayFormatters.formatDecimal(0.0, 0));
        System.out.println("123456:" + DisplayFormatters.formatDecimal(123456.0, 0));
        System.out.println("123456:" + DisplayFormatters.formatDecimal(123456.999, 0));
        System.out.println(DisplayFormatters.formatDecimal(Double.NaN, 3));
    }

    static {
        DisplayFormatters.setUnits();
    }
}

