/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.frostwire.util.Logger;

public class AESemaphore {
    private static final Logger LOG = Logger.getLogger(AESemaphore.class);
    private int waiting = 0;
    private int dont_wait;
    private int total_reserve = 0;
    private int total_release;
    private boolean released_forever = false;

    public AESemaphore() {
        this(0);
    }

    AESemaphore(int count) {
        this.dont_wait = count;
        this.total_release = count;
    }

    public void reserve() {
        this.reserveSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean reserveIfAvailable() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            if (this.released_forever || this.dont_wait > 0) {
                this.reserve();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reserveSupport() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            if (this.released_forever) {
                return;
            }
            if (this.dont_wait == 0) {
                try {
                    block9: {
                        ++this.waiting;
                        int spurious_count = 0;
                        do {
                            this.wait();
                            if (this.total_reserve != this.total_release) break block9;
                        } while (++spurious_count <= 1024);
                        LOG.error("AESemaphore: spurious wakeup limit exceeded");
                        throw new Throwable("die die die");
                    }
                    if (this.total_reserve == this.total_release) {
                        --this.waiting;
                        return;
                    }
                    ++this.total_reserve;
                }
                catch (Throwable e) {
                    --this.waiting;
                    LOG.error("**** semaphore operation interrupted ****");
                    throw new RuntimeException("Semaphore: operation interrupted", e);
                }
            }
            int num_to_get = Math.min(1, this.dont_wait);
            this.dont_wait -= num_to_get;
            this.total_reserve += num_to_get;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            ++this.total_release;
            if (this.waiting != 0) {
                --this.waiting;
                this.notify();
            } else {
                ++this.dont_wait;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAllWaiters() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            int x = this.waiting;
            for (int i2 = 0; i2 < x; ++i2) {
                this.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseForever() {
        AESemaphore aESemaphore = this;
        synchronized (aESemaphore) {
            this.releaseAllWaiters();
            this.released_forever = true;
        }
    }
}

