/*
 * Decompiled with CFR 0.152.
 */
package okio.internal;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ByteString;
import okio.Segment;
import okio.SegmentedByteString;
import okio._UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a-\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0080\b\u001a\u0017\u0010\u000e\u001a\u00020\u000f*\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0080\b\u001a\r\u0010\u0012\u001a\u00020\u0001*\u00020\bH\u0080\b\u001a\r\u0010\u0013\u001a\u00020\u0001*\u00020\bH\u0080\b\u001a\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0001H\u0080\b\u001a-\u0010\u0017\u001a\u00020\u000f*\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0080\b\u001a-\u0010\u0017\u001a\u00020\u000f*\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0080\b\u001a\u001d\u0010\u001a\u001a\u00020\u0019*\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001H\u0080\b\u001a\r\u0010\u001d\u001a\u00020\u000b*\u00020\bH\u0080\b\u001a%\u0010\u001e\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0080\b\u001a]\u0010!\u001a\u00020\u0007*\u00020\b2K\u0010\"\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00070#H\u0080\b\u00f8\u0001\u0000\u001aj\u0010!\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00012K\u0010\"\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00070#H\u0082\b\u001a\u0014\u0010'\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0001H\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006("}, d2={"binarySearch", "", "", "value", "fromIndex", "toIndex", "commonCopyInto", "", "Lokio/SegmentedByteString;", "offset", "target", "", "targetOffset", "byteCount", "commonEquals", "", "other", "", "commonGetSize", "commonHashCode", "commonInternalGet", "", "pos", "commonRangeEquals", "otherOffset", "Lokio/ByteString;", "commonSubstring", "beginIndex", "endIndex", "commonToByteArray", "commonWrite", "buffer", "Lokio/Buffer;", "forEachSegment", "action", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "data", "segment", "okio"})
public final class _SegmentedByteStringKt {
    public static final int binarySearch(@NotNull int[] $this$binarySearch, int value, int fromIndex, int toIndex) {
        Intrinsics.checkNotNullParameter($this$binarySearch, "<this>");
        int left = fromIndex;
        int right = toIndex - 1;
        while (left <= right) {
            int mid = left + right >>> 1;
            int midVal = $this$binarySearch[mid];
            if (midVal < value) {
                left = mid + 1;
                continue;
            }
            if (midVal > value) {
                right = mid - 1;
                continue;
            }
            return mid;
        }
        return -left - 1;
    }

    public static final int segment(@NotNull SegmentedByteString $this$segment, int pos) {
        Intrinsics.checkNotNullParameter($this$segment, "<this>");
        int i2 = _SegmentedByteStringKt.binarySearch($this$segment.getDirectory$okio(), pos + 1, 0, ((Object[])$this$segment.getSegments$okio()).length);
        return i2 >= 0 ? i2 : ~i2;
    }

    public static final void forEachSegment(@NotNull SegmentedByteString $this$forEachSegment, @NotNull Function3<? super byte[], ? super Integer, ? super Integer, Unit> action) {
        Intrinsics.checkNotNullParameter($this$forEachSegment, "<this>");
        Intrinsics.checkNotNullParameter(action, "action");
        boolean $i$f$forEachSegment = false;
        int segmentCount = ((Object[])$this$forEachSegment.getSegments$okio()).length;
        int s = 0;
        int pos = 0;
        while (s < segmentCount) {
            int segmentPos = $this$forEachSegment.getDirectory$okio()[segmentCount + s];
            int nextSegmentOffset = $this$forEachSegment.getDirectory$okio()[s];
            action.invoke((byte[])$this$forEachSegment.getSegments$okio()[s], (Integer)segmentPos, (Integer)(nextSegmentOffset - pos));
            pos = nextSegmentOffset;
            int n = s;
            s = n + 1;
        }
    }

    private static final void forEachSegment(SegmentedByteString $this$forEachSegment, int beginIndex, int endIndex, Function3<? super byte[], ? super Integer, ? super Integer, Unit> action) {
        int byteCount;
        boolean $i$f$forEachSegment = false;
        int s = _SegmentedByteStringKt.segment($this$forEachSegment, beginIndex);
        for (int pos = beginIndex; pos < endIndex; pos += byteCount) {
            int segmentOffset = s == 0 ? 0 : $this$forEachSegment.getDirectory$okio()[s - 1];
            int segmentSize = $this$forEachSegment.getDirectory$okio()[s] - segmentOffset;
            int segmentPos = $this$forEachSegment.getDirectory$okio()[((Object[])$this$forEachSegment.getSegments$okio()).length + s];
            int n = segmentOffset + segmentSize;
            int n2 = 0;
            byteCount = Math.min(endIndex, n) - pos;
            int offset = segmentPos + (pos - segmentOffset);
            action.invoke((byte[])$this$forEachSegment.getSegments$okio()[s], (Integer)offset, (Integer)byteCount);
            n2 = s;
            s = n2 + 1;
        }
    }

    @NotNull
    public static final ByteString commonSubstring(@NotNull SegmentedByteString $this$commonSubstring, int beginIndex, int endIndex) {
        int n;
        Intrinsics.checkNotNullParameter($this$commonSubstring, "<this>");
        boolean $i$f$commonSubstring = false;
        int endIndex2 = _UtilKt.resolveDefaultParameter($this$commonSubstring, endIndex);
        boolean bl = beginIndex >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "beginIndex=" + beginIndex + " < 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = endIndex2 <= $this$commonSubstring.size();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl52 = false;
            String string = "endIndex=" + endIndex2 + " > length(" + $this$commonSubstring.size() + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int subLen = endIndex2 - beginIndex;
        bl2 = subLen >= 0;
        bl3 = false;
        boolean bl52 = false;
        if (!bl2) {
            boolean bl6 = false;
            String bl52 = "endIndex=" + endIndex2 + " < beginIndex=" + beginIndex;
            throw (Throwable)new IllegalArgumentException(bl52.toString());
        }
        if (beginIndex == 0 && endIndex2 == $this$commonSubstring.size()) {
            return $this$commonSubstring;
        }
        if (beginIndex == endIndex2) {
            return ByteString.EMPTY;
        }
        int beginSegment = _SegmentedByteStringKt.segment($this$commonSubstring, beginIndex);
        int endSegment = _SegmentedByteStringKt.segment($this$commonSubstring, endIndex2 - 1);
        Object[] bl6 = (Object[])$this$commonSubstring.getSegments$okio();
        int n2 = endSegment + 1;
        int n3 = 0;
        byte[][] newSegments = (byte[][])ArraysKt.copyOfRange(bl6, beginSegment, n2);
        int[] newDirectory = new int[((Object[])newSegments).length * 2];
        int index = 0;
        n3 = beginSegment;
        if (n3 <= endSegment) {
            int s;
            do {
                s = n3++;
                n = $this$commonSubstring.getDirectory$okio()[s] - beginIndex;
                boolean bl7 = false;
                newDirectory[index] = Math.min(n, subLen);
                n = index;
                index = n + 1;
                newDirectory[n + ((Object[])newSegments).length] = $this$commonSubstring.getDirectory$okio()[s + ((Object[])$this$commonSubstring.getSegments$okio()).length];
            } while (s != endSegment);
        }
        int segmentOffset = beginSegment == 0 ? 0 : $this$commonSubstring.getDirectory$okio()[beginSegment - 1];
        int[] nArray = newDirectory;
        n = ((Object[])newSegments).length;
        nArray[n] = nArray[n] + (beginIndex - segmentOffset);
        return new SegmentedByteString(newSegments, newDirectory);
    }

    public static final byte commonInternalGet(@NotNull SegmentedByteString $this$commonInternalGet, int pos) {
        Intrinsics.checkNotNullParameter($this$commonInternalGet, "<this>");
        boolean $i$f$commonInternalGet = false;
        _UtilKt.checkOffsetAndCount($this$commonInternalGet.getDirectory$okio()[((Object[])$this$commonInternalGet.getSegments$okio()).length - 1], pos, 1L);
        int segment = _SegmentedByteStringKt.segment($this$commonInternalGet, pos);
        int segmentOffset = segment == 0 ? 0 : $this$commonInternalGet.getDirectory$okio()[segment - 1];
        int segmentPos = $this$commonInternalGet.getDirectory$okio()[segment + ((Object[])$this$commonInternalGet.getSegments$okio()).length];
        return $this$commonInternalGet.getSegments$okio()[segment][pos - segmentOffset + segmentPos];
    }

    public static final int commonGetSize(@NotNull SegmentedByteString $this$commonGetSize) {
        Intrinsics.checkNotNullParameter($this$commonGetSize, "<this>");
        boolean $i$f$commonGetSize = false;
        return $this$commonGetSize.getDirectory$okio()[((Object[])$this$commonGetSize.getSegments$okio()).length - 1];
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] commonToByteArray(@NotNull SegmentedByteString $this$commonToByteArray) {
        Intrinsics.checkNotNullParameter($this$commonToByteArray, "<this>");
        boolean $i$f$commonToByteArray = false;
        byte[] result = new byte[$this$commonToByteArray.size()];
        int resultPos = 0;
        SegmentedByteString $this$forEachSegment$iv = $this$commonToByteArray;
        boolean $i$f$forEachSegment = false;
        int segmentCount$iv = ((Object[])$this$forEachSegment$iv.getSegments$okio()).length;
        int s$iv = 0;
        int pos$iv = 0;
        while (s$iv < segmentCount$iv) {
            void byteCount;
            void offset;
            int segmentPos$iv = $this$forEachSegment$iv.getDirectory$okio()[segmentCount$iv + s$iv];
            int nextSegmentOffset$iv = $this$forEachSegment$iv.getDirectory$okio()[s$iv];
            int n = nextSegmentOffset$iv - pos$iv;
            int n2 = segmentPos$iv;
            byte[] data = $this$forEachSegment$iv.getSegments$okio()[s$iv];
            boolean bl = false;
            ArraysKt.copyInto(data, result, resultPos, (int)offset, (int)(offset + byteCount));
            resultPos += byteCount;
            pos$iv = nextSegmentOffset$iv;
            int n3 = s$iv;
            s$iv = n3 + 1;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static final void commonWrite(@NotNull SegmentedByteString $this$commonWrite, @NotNull Buffer buffer, int offset, int byteCount) {
        int byteCount$iv;
        void $this$forEachSegment$iv;
        Intrinsics.checkNotNullParameter($this$commonWrite, "<this>");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        boolean $i$f$commonWrite = false;
        Object object = $this$commonWrite;
        int endIndex$iv = offset + byteCount;
        boolean $i$f$forEachSegment = false;
        int s$iv = _SegmentedByteStringKt.segment((SegmentedByteString)$this$forEachSegment$iv, offset);
        for (int pos$iv = offset; pos$iv < endIndex$iv; pos$iv += byteCount$iv) {
            void byteCount2;
            void offset2;
            int segmentOffset$iv = s$iv == 0 ? 0 : $this$forEachSegment$iv.getDirectory$okio()[s$iv - 1];
            int segmentSize$iv = $this$forEachSegment$iv.getDirectory$okio()[s$iv] - segmentOffset$iv;
            int segmentPos$iv = $this$forEachSegment$iv.getDirectory$okio()[((Object[])$this$forEachSegment$iv.getSegments$okio()).length + s$iv];
            int n = segmentOffset$iv + segmentSize$iv;
            int n2 = 0;
            byteCount$iv = Math.min(endIndex$iv, n) - pos$iv;
            int offset$iv = segmentPos$iv + (pos$iv - segmentOffset$iv);
            int n3 = byteCount$iv;
            int n4 = offset$iv;
            byte[] data = $this$forEachSegment$iv.getSegments$okio()[s$iv];
            boolean bl = false;
            Segment segment = new Segment(data, (int)offset2, (int)(offset2 + byteCount2), true, false);
            if (buffer.head == null) {
                buffer.head = segment.next = (segment.prev = segment);
            } else {
                Segment segment2 = buffer.head;
                Intrinsics.checkNotNull(segment2);
                Segment segment3 = segment2.prev;
                Intrinsics.checkNotNull(segment3);
                segment3.push(segment);
            }
            n2 = s$iv;
            s$iv = n2 + 1;
        }
        object = buffer;
        ((Buffer)object).setSize$okio(((Buffer)object).size() + (long)byteCount);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean commonRangeEquals(@NotNull SegmentedByteString $this$commonRangeEquals, int offset, @NotNull ByteString other, int otherOffset, int byteCount) {
        int byteCount$iv;
        void $this$forEachSegment$iv;
        Intrinsics.checkNotNullParameter($this$commonRangeEquals, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        boolean $i$f$commonRangeEquals = false;
        if (offset < 0 || offset > $this$commonRangeEquals.size() - byteCount) {
            return false;
        }
        int otherOffset2 = 0;
        otherOffset2 = otherOffset;
        SegmentedByteString segmentedByteString = $this$commonRangeEquals;
        int endIndex$iv = offset + byteCount;
        boolean $i$f$forEachSegment = false;
        int s$iv = _SegmentedByteStringKt.segment((SegmentedByteString)$this$forEachSegment$iv, offset);
        for (int pos$iv = offset; pos$iv < endIndex$iv; pos$iv += byteCount$iv) {
            void byteCount2;
            void offset2;
            int segmentOffset$iv = s$iv == 0 ? 0 : $this$forEachSegment$iv.getDirectory$okio()[s$iv - 1];
            int segmentSize$iv = $this$forEachSegment$iv.getDirectory$okio()[s$iv] - segmentOffset$iv;
            int segmentPos$iv = $this$forEachSegment$iv.getDirectory$okio()[((Object[])$this$forEachSegment$iv.getSegments$okio()).length + s$iv];
            int n = segmentOffset$iv + segmentSize$iv;
            int n2 = 0;
            byteCount$iv = Math.min(endIndex$iv, n) - pos$iv;
            int offset$iv = segmentPos$iv + (pos$iv - segmentOffset$iv);
            int n3 = byteCount$iv;
            int n4 = offset$iv;
            byte[] data = $this$forEachSegment$iv.getSegments$okio()[s$iv];
            boolean bl = false;
            if (!other.rangeEquals(otherOffset2, data, (int)offset2, (int)byteCount2)) {
                return false;
            }
            otherOffset2 += byteCount2;
            n2 = s$iv;
            s$iv = n2 + 1;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean commonRangeEquals(@NotNull SegmentedByteString $this$commonRangeEquals, int offset, @NotNull byte[] other, int otherOffset, int byteCount) {
        int byteCount$iv;
        void $this$forEachSegment$iv;
        Intrinsics.checkNotNullParameter($this$commonRangeEquals, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        boolean $i$f$commonRangeEquals = false;
        if (offset < 0 || offset > $this$commonRangeEquals.size() - byteCount || otherOffset < 0 || otherOffset > other.length - byteCount) {
            return false;
        }
        int otherOffset2 = 0;
        otherOffset2 = otherOffset;
        SegmentedByteString segmentedByteString = $this$commonRangeEquals;
        int endIndex$iv = offset + byteCount;
        boolean $i$f$forEachSegment = false;
        int s$iv = _SegmentedByteStringKt.segment((SegmentedByteString)$this$forEachSegment$iv, offset);
        for (int pos$iv = offset; pos$iv < endIndex$iv; pos$iv += byteCount$iv) {
            void byteCount2;
            void offset2;
            int segmentOffset$iv = s$iv == 0 ? 0 : $this$forEachSegment$iv.getDirectory$okio()[s$iv - 1];
            int segmentSize$iv = $this$forEachSegment$iv.getDirectory$okio()[s$iv] - segmentOffset$iv;
            int segmentPos$iv = $this$forEachSegment$iv.getDirectory$okio()[((Object[])$this$forEachSegment$iv.getSegments$okio()).length + s$iv];
            int n = segmentOffset$iv + segmentSize$iv;
            int n2 = 0;
            byteCount$iv = Math.min(endIndex$iv, n) - pos$iv;
            int offset$iv = segmentPos$iv + (pos$iv - segmentOffset$iv);
            int n3 = byteCount$iv;
            int n4 = offset$iv;
            byte[] data = $this$forEachSegment$iv.getSegments$okio()[s$iv];
            boolean bl = false;
            if (!_UtilKt.arrayRangeEquals(data, (int)offset2, other, otherOffset2, (int)byteCount2)) {
                return false;
            }
            otherOffset2 += byteCount2;
            n2 = s$iv;
            s$iv = n2 + 1;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static final void commonCopyInto(@NotNull SegmentedByteString $this$commonCopyInto, int offset, @NotNull byte[] target, int targetOffset, int byteCount) {
        int byteCount$iv;
        void $this$forEachSegment$iv;
        Intrinsics.checkNotNullParameter($this$commonCopyInto, "<this>");
        Intrinsics.checkNotNullParameter(target, "target");
        boolean $i$f$commonCopyInto = false;
        _UtilKt.checkOffsetAndCount($this$commonCopyInto.size(), offset, byteCount);
        _UtilKt.checkOffsetAndCount(target.length, targetOffset, byteCount);
        int targetOffset2 = 0;
        targetOffset2 = targetOffset;
        SegmentedByteString segmentedByteString = $this$commonCopyInto;
        int endIndex$iv = offset + byteCount;
        boolean $i$f$forEachSegment = false;
        int s$iv = _SegmentedByteStringKt.segment((SegmentedByteString)$this$forEachSegment$iv, offset);
        for (int pos$iv = offset; pos$iv < endIndex$iv; pos$iv += byteCount$iv) {
            void byteCount2;
            void offset2;
            int segmentOffset$iv = s$iv == 0 ? 0 : $this$forEachSegment$iv.getDirectory$okio()[s$iv - 1];
            int segmentSize$iv = $this$forEachSegment$iv.getDirectory$okio()[s$iv] - segmentOffset$iv;
            int segmentPos$iv = $this$forEachSegment$iv.getDirectory$okio()[((Object[])$this$forEachSegment$iv.getSegments$okio()).length + s$iv];
            int n = segmentOffset$iv + segmentSize$iv;
            int n2 = 0;
            byteCount$iv = Math.min(endIndex$iv, n) - pos$iv;
            int offset$iv = segmentPos$iv + (pos$iv - segmentOffset$iv);
            int n3 = byteCount$iv;
            int n4 = offset$iv;
            byte[] data = $this$forEachSegment$iv.getSegments$okio()[s$iv];
            boolean bl = false;
            ArraysKt.copyInto(data, target, targetOffset2, (int)offset2, (int)(offset2 + byteCount2));
            targetOffset2 += byteCount2;
            n2 = s$iv;
            s$iv = n2 + 1;
        }
    }

    public static final boolean commonEquals(@NotNull SegmentedByteString $this$commonEquals, @Nullable Object other) {
        Intrinsics.checkNotNullParameter($this$commonEquals, "<this>");
        boolean $i$f$commonEquals = false;
        return other == $this$commonEquals ? true : (other instanceof ByteString ? ((ByteString)other).size() == $this$commonEquals.size() && $this$commonEquals.rangeEquals(0, (ByteString)other, 0, $this$commonEquals.size()) : false);
    }

    /*
     * WARNING - void declaration
     */
    public static final int commonHashCode(@NotNull SegmentedByteString $this$commonHashCode) {
        Intrinsics.checkNotNullParameter($this$commonHashCode, "<this>");
        boolean $i$f$commonHashCode = false;
        int result = 0;
        result = $this$commonHashCode.getHashCode$okio();
        if (result != 0) {
            return result;
        }
        result = 1;
        SegmentedByteString $this$forEachSegment$iv = $this$commonHashCode;
        boolean $i$f$forEachSegment = false;
        int segmentCount$iv = ((Object[])$this$forEachSegment$iv.getSegments$okio()).length;
        int s$iv = 0;
        int pos$iv = 0;
        while (s$iv < segmentCount$iv) {
            void byteCount;
            void offset;
            int segmentPos$iv = $this$forEachSegment$iv.getDirectory$okio()[segmentCount$iv + s$iv];
            int nextSegmentOffset$iv = $this$forEachSegment$iv.getDirectory$okio()[s$iv];
            int n = nextSegmentOffset$iv - pos$iv;
            int n2 = segmentPos$iv;
            byte[] data = $this$forEachSegment$iv.getSegments$okio()[s$iv];
            boolean bl = false;
            void i2 = offset;
            void limit = offset + byteCount;
            while (i2 < limit) {
                result = 31 * result + data[i2];
                void var16_17 = i2;
                i2 = var16_17 + true;
            }
            pos$iv = nextSegmentOffset$iv;
            int n3 = s$iv;
            s$iv = n3 + 1;
        }
        $this$commonHashCode.setHashCode$okio(result);
        return result;
    }
}

