/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.swing;

import java.awt.BasicStroke;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Label;
import java.awt.List;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ContainerWrapper;
import net.miginfocom.layout.PlatformDefaults;
import net.miginfocom.swing.SwingContainerWrapper;

public class SwingComponentWrapper
implements ComponentWrapper {
    private static final Color DB_COMP_OUTLINE = new Color(0, 0, 200);
    private static final IdentityHashMap<FontMetrics, Point2D.Float> FM_MAP = new IdentityHashMap(4);
    private static final Font SUBST_FONT = new Font("sansserif", 0, 11);
    private static Method BL_METHOD = null;
    private static Method BL_RES_METHOD = null;
    private static Method IMS_METHOD = null;
    private final Component c;
    private int compType = -1;
    private Boolean bl = null;
    private boolean prefCalled = false;

    SwingComponentWrapper(Component c) {
        this.c = c;
    }

    private static boolean isMaxSizeSetOn1_4() {
        return false;
    }

    @Override
    public final int getBaseline(int width, int height) {
        if (BL_METHOD == null) {
            return -1;
        }
        try {
            Object[] args2 = new Object[]{width < 0 ? this.c.getWidth() : width, height < 0 ? this.c.getHeight() : height};
            return (Integer)BL_METHOD.invoke((Object)this.c, args2);
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public final Object getComponent() {
        return this.c;
    }

    @Override
    public final float getPixelUnitFactor(boolean isHor) {
        switch (PlatformDefaults.getLogicalPixelBase()) {
            case 100: {
                Font font = this.c.getFont();
                FontMetrics fm = this.c.getFontMetrics(font != null ? font : SUBST_FONT);
                Point2D.Float p = FM_MAP.get(fm);
                if (p == null) {
                    Rectangle2D r = fm.getStringBounds("X", this.c.getGraphics());
                    p = new Point2D.Float((float)r.getWidth() / 6.0f, (float)r.getHeight() / 13.277344f);
                    FM_MAP.put(fm, p);
                }
                return isHor ? p.x : p.y;
            }
            case 101: {
                Float s;
                Float f = s = isHor ? PlatformDefaults.getHorizontalScaleFactor() : PlatformDefaults.getVerticalScaleFactor();
                if (s != null) {
                    return s.floatValue();
                }
                return (float)(isHor ? this.getHorizontalScreenDPI() : this.getVerticalScreenDPI()) / (float)PlatformDefaults.getDefaultDPI();
            }
        }
        return 1.0f;
    }

    @Override
    public final int getX() {
        return this.c.getX();
    }

    @Override
    public final int getY() {
        return this.c.getY();
    }

    @Override
    public final int getHeight() {
        return this.c.getHeight();
    }

    @Override
    public final int getWidth() {
        return this.c.getWidth();
    }

    @Override
    public final int getScreenLocationX() {
        Point p = new Point();
        SwingUtilities.convertPointToScreen(p, this.c);
        return p.x;
    }

    @Override
    public final int getScreenLocationY() {
        Point p = new Point();
        SwingUtilities.convertPointToScreen(p, this.c);
        return p.y;
    }

    @Override
    public final int getMinimumHeight(int sz) {
        if (!this.prefCalled) {
            this.c.getPreferredSize();
            this.prefCalled = true;
        }
        return this.c.getMinimumSize().height;
    }

    @Override
    public final int getMinimumWidth(int sz) {
        if (!this.prefCalled) {
            this.c.getPreferredSize();
            this.prefCalled = true;
        }
        return this.c.getMinimumSize().width;
    }

    @Override
    public final int getPreferredHeight(int sz) {
        if (this.c.getWidth() == 0 && this.c.getHeight() == 0 && sz != -1) {
            this.c.setBounds(this.c.getX(), this.c.getY(), sz, 1);
        }
        return this.c.getPreferredSize().height;
    }

    @Override
    public final int getPreferredWidth(int sz) {
        if (this.c.getWidth() == 0 && this.c.getHeight() == 0 && sz != -1) {
            this.c.setBounds(this.c.getX(), this.c.getY(), 1, sz);
        }
        return this.c.getPreferredSize().width;
    }

    @Override
    public final int getMaximumHeight(int sz) {
        if (!this.isMaxSet(this.c)) {
            return Short.MAX_VALUE;
        }
        return this.c.getMaximumSize().height;
    }

    @Override
    public final int getMaximumWidth(int sz) {
        if (!this.isMaxSet(this.c)) {
            return Short.MAX_VALUE;
        }
        return this.c.getMaximumSize().width;
    }

    private boolean isMaxSet(Component c) {
        if (IMS_METHOD != null) {
            try {
                return (Boolean)IMS_METHOD.invoke((Object)c, (Object[])null);
            }
            catch (Exception e) {
                IMS_METHOD = null;
            }
        }
        return SwingComponentWrapper.isMaxSizeSetOn1_4();
    }

    @Override
    public final ContainerWrapper getParent() {
        Container p = this.c.getParent();
        return p != null ? new SwingContainerWrapper(p) : null;
    }

    @Override
    public final int getHorizontalScreenDPI() {
        return PlatformDefaults.getDefaultDPI();
    }

    @Override
    public final int getVerticalScreenDPI() {
        return PlatformDefaults.getDefaultDPI();
    }

    @Override
    public final int getScreenWidth() {
        try {
            return this.c.getToolkit().getScreenSize().width;
        }
        catch (HeadlessException ex) {
            return 1024;
        }
    }

    @Override
    public final int getScreenHeight() {
        try {
            return this.c.getToolkit().getScreenSize().height;
        }
        catch (HeadlessException ex) {
            return 768;
        }
    }

    @Override
    public final boolean hasBaseline() {
        if (this.bl == null) {
            try {
                if (BL_RES_METHOD == null || BL_RES_METHOD.invoke((Object)this.c, new Object[0]).toString().equals("OTHER")) {
                    this.bl = Boolean.FALSE;
                } else {
                    Dimension d = this.c.getMinimumSize();
                    this.bl = this.getBaseline(d.width, d.height) > -1;
                }
            }
            catch (Throwable ex) {
                this.bl = Boolean.FALSE;
            }
        }
        return this.bl;
    }

    @Override
    public final String getLinkId() {
        return this.c.getName();
    }

    @Override
    public final void setBounds(int x, int y, int width, int height) {
        this.c.setBounds(x, y, width, height);
    }

    @Override
    public boolean isVisible() {
        return this.c.isVisible();
    }

    @Override
    public final int[] getVisualPadding() {
        boolean vp = true;
        if (vp && this.c instanceof JTabbedPane && UIManager.getLookAndFeel().getClass().getName().endsWith("WindowsLookAndFeel")) {
            return new int[]{-1, 0, 2, 2};
        }
        return null;
    }

    @Override
    public final void paintDebugOutline() {
        if (!this.c.isShowing()) {
            return;
        }
        Graphics2D g = (Graphics2D)this.c.getGraphics();
        if (g == null) {
            return;
        }
        g.setPaint(DB_COMP_OUTLINE);
        g.setStroke(new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{2.0f, 4.0f}, 0.0f));
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    @Override
    public int getLayoutHashCode() {
        String id;
        Dimension d = this.c.getMaximumSize();
        int hash = d.width + (d.height << 5);
        d = this.c.getPreferredSize();
        hash += (d.width << 10) + (d.height << 15);
        d = this.c.getMinimumSize();
        hash += (d.width << 20) + (d.height << 25);
        if (this.c.isVisible()) {
            hash += 1324511;
        }
        if ((id = this.getLinkId()) != null) {
            hash += id.hashCode();
        }
        return hash;
    }

    private int checkType(boolean disregardScrollPane) {
        Component c = this.c;
        if (disregardScrollPane) {
            if (c instanceof JScrollPane) {
                c = ((JScrollPane)c).getViewport().getView();
            } else if (c instanceof ScrollPane) {
                c = ((ScrollPane)c).getComponent(0);
            }
        }
        if (c instanceof JTextField || c instanceof TextField) {
            return 3;
        }
        if (c instanceof JLabel || c instanceof Label) {
            return 2;
        }
        if (c instanceof JToggleButton || c instanceof Checkbox) {
            return 16;
        }
        if (c instanceof AbstractButton || c instanceof Button) {
            return 5;
        }
        if (c instanceof JComboBox || c instanceof Choice) {
            return 2;
        }
        if (c instanceof JTextComponent || c instanceof TextComponent) {
            return 4;
        }
        if (c instanceof JPanel || c instanceof Canvas) {
            return 10;
        }
        if (c instanceof JList || c instanceof List) {
            return 6;
        }
        if (c instanceof JTable) {
            return 7;
        }
        if (c instanceof JSeparator) {
            return 18;
        }
        if (c instanceof JSpinner) {
            return 13;
        }
        if (c instanceof JProgressBar) {
            return 14;
        }
        if (c instanceof JSlider) {
            return 12;
        }
        if (c instanceof JScrollPane) {
            return 8;
        }
        if (c instanceof JScrollBar || c instanceof Scrollbar) {
            return 17;
        }
        if (c instanceof Container) {
            return 1;
        }
        return 0;
    }

    public final int hashCode() {
        return this.getComponent().hashCode();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ComponentWrapper)) {
            return false;
        }
        return this.getComponent().equals(((ComponentWrapper)o).getComponent());
    }

    static {
        try {
            BL_METHOD = Component.class.getDeclaredMethod("getBaseline", Integer.TYPE, Integer.TYPE);
            BL_RES_METHOD = Component.class.getDeclaredMethod("getBaselineResizeBehavior", new Class[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            IMS_METHOD = Component.class.getDeclaredMethod("isMaximumSizeSet", null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

