/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.layout;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.LayoutUtil;
import net.miginfocom.layout.UnitValue;

public final class CC
implements Externalizable {
    private static final BoundSize DEF_GAP = BoundSize.NULL_SIZE;
    private static final String[] EMPTY_ARR = new String[0];
    private int dock = -1;
    private UnitValue[] pos = null;
    private UnitValue[] padding = null;
    private Boolean flowX = null;
    private int skip = 0;
    private int split = 1;
    private int spanX = 1;
    private int spanY = 1;
    private int cellX = -1;
    private int cellY = 0;
    private String tag = null;
    private String id = null;
    private int hideMode = -1;
    private final DimConstraint hor = new DimConstraint();
    private final DimConstraint ver = new DimConstraint();
    private BoundSize newline = null;
    private BoundSize wrap = null;
    private boolean boundsInGrid = true;
    private boolean external = false;
    private Float pushX = null;
    private Float pushY = null;
    private transient String[] linkTargets = null;

    String[] getLinkTargets() {
        if (this.linkTargets == null) {
            ArrayList<String> targets = new ArrayList<String>(2);
            if (this.pos != null) {
                for (UnitValue po : this.pos) {
                    this.addLinkTargetIDs(targets, po);
                }
            }
            this.linkTargets = targets.size() == 0 ? EMPTY_ARR : targets.toArray(new String[0]);
        }
        return this.linkTargets;
    }

    private void addLinkTargetIDs(ArrayList<String> targets, UnitValue uv) {
        if (uv != null) {
            String linkId = uv.getLinkTargetId();
            if (linkId != null) {
                targets.add(linkId);
            } else {
                for (int i2 = uv.getSubUnitCount() - 1; i2 >= 0; --i2) {
                    UnitValue subUv = uv.getSubUnitValue(i2);
                    if (!subUv.isLinkedDeep()) continue;
                    this.addLinkTargetIDs(targets, subUv);
                }
            }
        }
    }

    public DimConstraint getHorizontal() {
        return this.hor;
    }

    public DimConstraint getVertical() {
        return this.ver;
    }

    DimConstraint getDimConstraint(boolean isHor) {
        return isHor ? this.hor : this.ver;
    }

    public UnitValue[] getPos() {
        UnitValue[] unitValueArray;
        if (this.pos != null) {
            UnitValue[] unitValueArray2 = new UnitValue[4];
            unitValueArray2[0] = this.pos[0];
            unitValueArray2[1] = this.pos[1];
            unitValueArray2[2] = this.pos[2];
            unitValueArray = unitValueArray2;
            unitValueArray2[3] = this.pos[3];
        } else {
            unitValueArray = null;
        }
        return unitValueArray;
    }

    public void setPos(UnitValue[] pos) {
        UnitValue[] unitValueArray;
        if (pos != null) {
            UnitValue[] unitValueArray2 = new UnitValue[4];
            unitValueArray2[0] = pos[0];
            unitValueArray2[1] = pos[1];
            unitValueArray2[2] = pos[2];
            unitValueArray = unitValueArray2;
            unitValueArray2[3] = pos[3];
        } else {
            unitValueArray = null;
        }
        this.pos = unitValueArray;
        this.linkTargets = null;
    }

    boolean isBoundsInGrid() {
        return this.boundsInGrid;
    }

    void setBoundsInGrid(boolean b) {
        this.boundsInGrid = b;
    }

    int getCellX() {
        return this.cellX;
    }

    void setCellX(int x) {
        this.cellX = x;
    }

    int getCellY() {
        return this.cellX < 0 ? -1 : this.cellY;
    }

    void setCellY(int y) {
        if (y < 0) {
            this.cellX = -1;
        }
        this.cellY = Math.max(y, 0);
    }

    int getDockSide() {
        return this.dock;
    }

    void setDockSide(int side) {
        if (side < -1 || side > 3) {
            throw new IllegalArgumentException("Illegal dock side: " + side);
        }
        this.dock = side;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean b) {
        this.external = b;
    }

    Boolean getFlowX() {
        return this.flowX;
    }

    void setFlowX(Boolean b) {
        this.flowX = b;
    }

    int getHideMode() {
        return this.hideMode;
    }

    void setHideMode(int mode) {
        if (mode < -1 || mode > 3) {
            throw new IllegalArgumentException("Wrong hideMode: " + mode);
        }
        this.hideMode = mode;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UnitValue[] getPadding() {
        UnitValue[] unitValueArray;
        if (this.padding != null) {
            UnitValue[] unitValueArray2 = new UnitValue[4];
            unitValueArray2[0] = this.padding[0];
            unitValueArray2[1] = this.padding[1];
            unitValueArray2[2] = this.padding[2];
            unitValueArray = unitValueArray2;
            unitValueArray2[3] = this.padding[3];
        } else {
            unitValueArray = null;
        }
        return unitValueArray;
    }

    public void setPadding(UnitValue[] sides) {
        UnitValue[] unitValueArray;
        if (sides != null) {
            UnitValue[] unitValueArray2 = new UnitValue[4];
            unitValueArray2[0] = sides[0];
            unitValueArray2[1] = sides[1];
            unitValueArray2[2] = sides[2];
            unitValueArray = unitValueArray2;
            unitValueArray2[3] = sides[3];
        } else {
            unitValueArray = null;
        }
        this.padding = unitValueArray;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int cells) {
        this.skip = cells;
    }

    int getSpanX() {
        return this.spanX;
    }

    void setSpanX(int cells) {
        this.spanX = cells;
    }

    int getSpanY() {
        return this.spanY;
    }

    void setSpanY(int cells) {
        this.spanY = cells;
    }

    Float getPushX() {
        return this.pushX;
    }

    void setPushX(Float weight) {
        this.pushX = weight;
    }

    Float getPushY() {
        return this.pushY;
    }

    void setPushY(Float weight) {
        this.pushY = weight;
    }

    public int getSplit() {
        return this.split;
    }

    public void setSplit(int parts) {
        this.split = parts;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public boolean isWrap() {
        return this.wrap != null;
    }

    public void setWrap(boolean b) {
        this.wrap = b ? (this.wrap == null ? DEF_GAP : this.wrap) : null;
    }

    BoundSize getWrapGapSize() {
        return this.wrap == DEF_GAP ? null : this.wrap;
    }

    void setWrapGapSize(BoundSize s) {
        this.wrap = s == null ? (this.wrap != null ? DEF_GAP : null) : s;
    }

    boolean isNewline() {
        return this.newline != null;
    }

    void setNewline(boolean b) {
        this.newline = b ? (this.newline == null ? DEF_GAP : this.newline) : null;
    }

    BoundSize getNewlineGapSize() {
        return this.newline == DEF_GAP ? null : this.newline;
    }

    void setNewlineGapSize(BoundSize s) {
        this.newline = s == null ? (this.newline != null ? DEF_GAP : null) : s;
    }

    private Object readResolve() {
        return LayoutUtil.getSerializedObject(this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        LayoutUtil.setSerializedObject(this, LayoutUtil.readAsXML(in));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.getClass() == CC.class) {
            LayoutUtil.writeAsXML(out, this);
        }
    }
}

