/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.layout;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.LayoutUtil;
import net.miginfocom.layout.UnitValue;

public final class AC
implements Externalizable {
    private final ArrayList<DimConstraint> cList = new ArrayList(8);

    AC() {
        this.cList.add(new DimConstraint());
    }

    final DimConstraint[] getConstaints() {
        return this.cList.toArray(new DimConstraint[0]);
    }

    final void setConstaints(DimConstraint[] constr) {
        if (constr == null || constr.length < 1) {
            constr = new DimConstraint[]{new DimConstraint()};
        }
        this.cList.clear();
        this.cList.ensureCapacity(constr.length);
        this.cList.addAll(Arrays.asList(constr));
    }

    public int getCount() {
        return this.cList.size();
    }

    public final AC fill(int ... indexes) {
        for (int i2 = indexes.length - 1; i2 >= 0; --i2) {
            int ix = indexes[i2];
            this.makeSize(ix);
            this.cList.get(ix).setFill(true);
        }
        return this;
    }

    public final AC size(String size, int ... indexes) {
        BoundSize bs = ConstraintParser.parseBoundSize(size, false, true);
        for (int i2 = indexes.length - 1; i2 >= 0; --i2) {
            int ix = indexes[i2];
            this.makeSize(ix);
            this.cList.get(ix).setSize(bs);
        }
        return this;
    }

    public final AC gap(String size, int ... indexes) {
        BoundSize bsa = size != null ? ConstraintParser.parseBoundSize(size, true, true) : null;
        for (int i2 = indexes.length - 1; i2 >= 0; --i2) {
            int ix = indexes[i2];
            this.makeSize(ix);
            if (bsa == null) continue;
            this.cList.get(ix).setGapAfter(bsa);
        }
        return this;
    }

    public final AC align(String side, int ... indexes) {
        UnitValue al = ConstraintParser.parseAlignKeywords(side, true);
        if (al == null) {
            al = ConstraintParser.parseAlignKeywords(side, false);
        }
        for (int i2 = indexes.length - 1; i2 >= 0; --i2) {
            int ix = indexes[i2];
            this.makeSize(ix);
            this.cList.get(ix).setAlign(al);
        }
        return this;
    }

    public final AC grow(float w, int ... indexes) {
        Float gw = Float.valueOf(w);
        for (int i2 = indexes.length - 1; i2 >= 0; --i2) {
            int ix = indexes[i2];
            this.makeSize(ix);
            this.cList.get(ix).setGrow(gw);
        }
        return this;
    }

    private AC shrink(float w) {
        int curIx = 0;
        return this.shrink(w, curIx);
    }

    private AC shrink(float w, int ... indexes) {
        Float sw = Float.valueOf(w);
        for (int i2 = indexes.length - 1; i2 >= 0; --i2) {
            int ix = indexes[i2];
            this.makeSize(ix);
            this.cList.get(ix).setShrink(sw);
        }
        return this;
    }

    @Deprecated
    public final AC shrinkWeight(float w) {
        return this.shrink(w);
    }

    @Deprecated
    public final AC shrinkWeight(float w, int ... indexes) {
        return this.shrink(w, indexes);
    }

    private void makeSize(int sz) {
        if (this.cList.size() <= sz) {
            this.cList.ensureCapacity(sz);
            for (int i2 = this.cList.size(); i2 <= sz; ++i2) {
                this.cList.add(new DimConstraint());
            }
        }
    }

    private Object readResolve() {
        return LayoutUtil.getSerializedObject(this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        LayoutUtil.setSerializedObject(this, LayoutUtil.readAsXML(in));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.getClass() == AC.class) {
            LayoutUtil.writeAsXML(out, this);
        }
    }
}

