/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.settings.SearchSettings;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.util.I18NConvert;
import org.limewire.util.StringUtils;

public class QueryUtils {
    private static final String DELIMITERS = " -._+/*()\\,";
    private static final List<String> TRIVIAL_WORDS = Arrays.asList("the", "an", "a", "and", "com", "net", "org", "vol", "volume");

    private static Set<String> keywords(String fileName, boolean allowNumbers) {
        fileName = QueryUtils.ripExtension(fileName);
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        char[] illegal = SearchSettings.ILLEGAL_CHARS.getValue();
        StringTokenizer st = new StringTokenizer(fileName, String.valueOf(illegal) + DELIMITERS);
        while (st.hasMoreTokens()) {
            String currToken = st.nextToken().toLowerCase();
            if (!allowNumbers) {
                try {
                    Double.valueOf(currToken);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (TRIVIAL_WORDS.contains(currToken)) continue;
            ret.add(currToken);
        }
        return ret;
    }

    public static Set<String> keywords(String fileName) {
        return QueryUtils.keywords(fileName, false);
    }

    private static String removeIllegalChars(String name) {
        StringBuilder ret = new StringBuilder();
        char[] illegal = SearchSettings.ILLEGAL_CHARS.getValue();
        StringTokenizer st = new StringTokenizer(name, String.valueOf(illegal) + DELIMITERS);
        while (st.hasMoreTokens()) {
            ret.append(st.nextToken().trim()).append(" ");
        }
        return ret.toString().trim();
    }

    private static String ripExtension(String fileName) {
        int extStart = fileName.lastIndexOf(46);
        String retString = extStart == -1 ? fileName : fileName.substring(0, extStart);
        return retString;
    }

    private static String createQueryString(String name, boolean allowNumbers) {
        String retString;
        if (name == null) {
            throw new NullPointerException("null name");
        }
        name = I18NConvert.instance().getNorm(name);
        int maxLen = SearchSettings.MAX_QUERY_LENGTH.getValue();
        Set<String> keywords = QueryUtils.keywords(name, allowNumbers);
        if (keywords.isEmpty()) {
            retString = QueryUtils.removeIllegalChars(name);
            retString = StringUtils.truncate(retString, maxLen);
        } else {
            StringBuilder sb = new StringBuilder();
            int numWritten = 0;
            for (String currKey : keywords) {
                if (numWritten >= maxLen) break;
                if (numWritten + currKey.length() >= maxLen) continue;
                if (numWritten > 0) {
                    sb.append(" ");
                    ++numWritten;
                }
                sb.append(currKey);
                numWritten += currKey.length();
            }
            if ((retString = sb.toString()).equals("")) {
                retString = StringUtils.truncate(keywords.iterator().next(), maxLen);
            }
        }
        assert (retString.length() <= maxLen) : "Original filename: " + name + ", converted: " + retString;
        assert (keywords.isEmpty() || !retString.equals("")) : "Original filename: " + name;
        return retString;
    }

    public static String createQueryString(String name) {
        return QueryUtils.createQueryString(name, false);
    }
}

