/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.trees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.limewire.collection.CharSequenceKeyAnalyzer;
import org.limewire.collection.PatriciaTrie;
import org.limewire.util.I18NConvert;
import org.limewire.util.StringUtils;

public class FilteredTreeModel
implements TreeModel {
    private final boolean ignoreCase;
    private final FilteredTreeModelListener listener;
    private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private TreeModel model;
    private ParentProvider parentProvider;
    private final PatriciaTrie<String, List<Object>> searchTrie = new PatriciaTrie(new CharSequenceKeyAnalyzer());
    private Set<Object> visibleNodes;

    public FilteredTreeModel(DefaultTreeModel model, boolean ignoreCase) {
        this(model, ignoreCase, new TreeNodeParentProvider());
    }

    private FilteredTreeModel(TreeModel model, boolean ignoreCase, ParentProvider parentProvider) {
        this.ignoreCase = ignoreCase;
        this.listener = new FilteredTreeModelListener();
        this.setModel(model, parentProvider);
    }

    public void addSearchKey(Object node, String key) {
        key = this.normalize(key);
        List value = this.searchTrie.computeIfAbsent(key, k -> new ArrayList(1));
        value.add(node);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    public void filterByText(String text) {
        if ((text = this.normalize(text)) == null || text.length() == 0) {
            this.visibleNodes = null;
        } else {
            this.visibleNodes = new HashSet<Object>();
            String[] keywords = StringUtils.split(I18NConvert.instance().getNorm(text), " ");
            for (int i2 = 0; i2 < keywords.length; ++i2) {
                SortedMap<String, List<Object>> nodeListByKey = this.searchTrie.getPrefixedBy(keywords[i2]);
                if (i2 == 0) {
                    for (List<Object> nodes : nodeListByKey.values()) {
                        this.visibleNodes.addAll(nodes);
                    }
                    continue;
                }
                HashSet<Object> allNew = new HashSet<Object>();
                for (List<Object> nodes : nodeListByKey.values()) {
                    allNew.addAll(nodes);
                }
                this.visibleNodes.retainAll(allNew);
            }
            this.ensureParentsVisible();
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{this.model.getRoot()});
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(event);
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (this.visibleNodes == null) {
            return this.model.getChild(parent, index);
        }
        int visibleIndex = 0;
        int count = this.model.getChildCount(parent);
        for (int i2 = 0; i2 < count; ++i2) {
            Object node = this.model.getChild(parent, i2);
            if (!this.visibleNodes.contains(node) || index != visibleIndex++) continue;
            return node;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildCount(Object parent) {
        if (this.visibleNodes == null) {
            return this.model.getChildCount(parent);
        }
        int visibleCount = 0;
        int count = this.model.getChildCount(parent);
        for (int i2 = 0; i2 < count; ++i2) {
            if (!this.visibleNodes.contains(this.model.getChild(parent, i2))) continue;
            ++visibleCount;
        }
        return visibleCount;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (this.visibleNodes == null) {
            return this.model.getIndexOfChild(parent, child);
        }
        int visibleIndex = 0;
        int count = this.model.getChildCount(parent);
        for (int i2 = 0; i2 < count; ++i2) {
            Object node = this.model.getChild(parent, i2);
            if (!this.visibleNodes.contains(node)) continue;
            if (node == child) {
                return visibleIndex;
            }
            ++visibleIndex;
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.model.getRoot();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.model.isLeaf(node);
    }

    private boolean isVisible(Object node) {
        return this.visibleNodes == null || this.visibleNodes.contains(node);
    }

    private String normalize(String text) {
        if (text != null && this.ignoreCase) {
            text = text.toLowerCase();
        }
        return text;
    }

    private void reload() {
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{this.model.getRoot()});
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(event);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    private void setModel(TreeModel model, ParentProvider parentProvider) {
        if (model == null || parentProvider == null) {
            throw new IllegalArgumentException();
        }
        if (this.model != null) {
            this.model.removeTreeModelListener(this.listener);
        }
        this.model = model;
        this.parentProvider = parentProvider;
        this.model.addTreeModelListener(this.listener);
        this.searchTrie.clear();
        this.reset();
    }

    private void reset() {
        this.visibleNodes = null;
        this.reload();
    }

    private void ensureParentsVisible() {
        HashSet<Object> parentNodes = new HashSet<Object>();
        for (Object node : this.visibleNodes) {
            Object parentNode = this.parentProvider.getParent(node);
            while (parentNode != null) {
                parentNodes.add(parentNode);
                parentNode = this.parentProvider.getParent(parentNode);
            }
        }
        this.visibleNodes.addAll(parentNodes);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.model.valueForPathChanged(path, newValue);
    }

    public static class TreeNodeParentProvider
    implements ParentProvider {
        @Override
        public Object getParent(Object node) {
            return ((TreeNode)node).getParent();
        }
    }

    static interface ParentProvider {
        public Object getParent(Object var1);
    }

    private class FilteredTreeModelListener
    implements TreeModelListener {
        private FilteredTreeModelListener() {
        }

        TreeModelEvent refactorEvent(TreeModelEvent event) {
            if (FilteredTreeModel.this.visibleNodes != null) {
                ArrayList<Object> children = new ArrayList<Object>(event.getChildren().length);
                ArrayList<Integer> indicieList = new ArrayList<Integer>(event.getChildIndices().length);
                FilteredTreeModel.this.visibleNodes.addAll(Arrays.asList(event.getChildren()));
                Object parent = event.getTreePath().getLastPathComponent();
                for (Object node : event.getChildren()) {
                    children.add(node);
                    indicieList.add(FilteredTreeModel.this.getIndexOfChild(parent, node));
                }
                int[] indicies = new int[indicieList.size()];
                for (int i2 = 0; i2 < indicies.length; ++i2) {
                    indicies[i2] = (Integer)indicieList.get(i2);
                }
                event = new TreeModelEvent(event.getSource(), event.getTreePath(), indicies, children.toArray(new Object[0]));
            }
            return event;
        }

        @Override
        public void treeNodesChanged(TreeModelEvent event) {
            if (!FilteredTreeModel.this.isVisible(event.getTreePath().getLastPathComponent())) {
                return;
            }
            event = this.refactorEvent(event);
            for (TreeModelListener listener : FilteredTreeModel.this.listeners) {
                listener.treeNodesChanged(event);
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent event) {
            if (!FilteredTreeModel.this.isVisible(event.getTreePath().getLastPathComponent())) {
                return;
            }
            event = this.refactorEvent(event);
            for (TreeModelListener listener : FilteredTreeModel.this.listeners) {
                listener.treeNodesInserted(event);
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent event) {
            if (!FilteredTreeModel.this.isVisible(event.getTreePath().getLastPathComponent())) {
                return;
            }
            for (TreeModelListener listener : FilteredTreeModel.this.listeners) {
                listener.treeStructureChanged(event);
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent event) {
            if (!FilteredTreeModel.this.isVisible(event.getTreePath().getLastPathComponent())) {
                return;
            }
            for (TreeModelListener listener : FilteredTreeModel.this.listeners) {
                listener.treeStructureChanged(event);
            }
        }
    }
}

