/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.settings.TablesHandlerSettings;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.SettingsFactory;

public class TableSettings {
    private static final SettingsFactory FACTORY = TablesHandlerSettings.instance().getFactory();
    public static final IntSetting DEFAULT_TABLE_ROW_HEIGHT = FACTORY.createIntSetting("TABLE_ROW_HEIGHT", 22);
    private static final String SORT = "_SORT";
    private static final String TOOLTIP = " _TOOLTIP";
    public final BooleanSetting REAL_TIME_SORT;
    final BooleanSetting DISPLAY_TOOLTIPS;

    public TableSettings(String id) {
        this.REAL_TIME_SORT = FACTORY.createBooleanSetting(id + SORT, this.getDefaultSorting());
        this.DISPLAY_TOOLTIPS = FACTORY.createBooleanSetting(id + TOOLTIP, this.getDefaultTooltips());
    }

    private boolean getDefaultSorting() {
        return true;
    }

    protected boolean getDefaultTooltips() {
        return true;
    }

    public void revertToDefault() {
        this.REAL_TIME_SORT.revertToDefault();
        this.DISPLAY_TOOLTIPS.revertToDefault();
    }

    public boolean isDefault() {
        return this.REAL_TIME_SORT.isDefault() && this.DISPLAY_TOOLTIPS.isDefault();
    }
}

