/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.frostwire.gui.theme.SkinProgressBarUI;
import com.limegroup.gnutella.gui.tables.BeveledCellPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class ProgressBarRenderer
extends JProgressBar
implements TableCellRenderer {
    private boolean isSelected;

    ProgressBarRenderer() {
        this.setUI(SkinProgressBarUI.createUI(this));
        this.setStringPainted(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSel, boolean hasFocus, int row, int column) {
        this.isSelected = isSel;
        this.setValue(Math.min(100, this.getBarStatus(value)));
        this.setString(this.getDescription(value));
        this.syncFont(table, this);
        return this;
    }

    private String getDescription(Object value) {
        return this.getBarStatus(value) + " %";
    }

    private int getBarStatus(Object value) {
        return value == null ? 0 : (Integer)value;
    }

    @Override
    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
        if (!this.isSelected) {
            BeveledCellPainter.paintBorder(g, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        JComponent jp = (JComponent)p;
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && jp.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName.equals("text")) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private void syncFont(JTable table, JComponent c) {
        Font tableFont = table.getFont();
        if (tableFont != null && !tableFont.equals(c.getFont())) {
            c.setFont(tableFont);
        }
    }
}

