/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.SortHeaderRenderer;
import javax.swing.Icon;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class LimeTableColumn
extends TableColumn {
    private static TableCellRenderer HEADER_RENDERER;
    private static TableCellRenderer INVIS_RENDERER;
    private final boolean defaultVisibility;
    private final int defaultWidth;
    private final String messageId;
    private final String name;
    private final Icon icon;
    private final boolean visName;
    private final Class<?> clazz;
    private final boolean initialized;

    public LimeTableColumn(int model, String id, String name, int width, boolean vis, Class<?> clazz) {
        this(model, id, name, null, width, vis, clazz);
    }

    public LimeTableColumn(int model, String id, String name, int width, boolean vis, boolean visName, boolean resizable, Class<?> clazz) {
        this(model, id, name, null, width, vis, visName, clazz);
        this.setResizable(resizable);
        if (!resizable) {
            this.setMaxWidth(width);
            this.setMinWidth(width);
        }
    }

    public LimeTableColumn(int model, String id, String name, int width, boolean vis, boolean visName, Class<?> clazz) {
        this(model, id, name, null, width, vis, visName, clazz);
    }

    private LimeTableColumn(int model, String id, String name, Icon icon, int width, boolean vis, boolean visName, Class<?> clazz) {
        super(model);
        this.initialized = true;
        this.defaultVisibility = vis;
        this.defaultWidth = width;
        if (this.defaultWidth != -1) {
            super.setPreferredWidth(width);
        }
        this.messageId = id;
        super.setIdentifier(id);
        this.name = name;
        this.icon = icon;
        this.visName = visName;
        this.clazz = clazz;
        this.setHeaderVisible(true);
    }

    public LimeTableColumn(int model, String id, String name, Icon icon, int width, boolean vis, Class<?> clazz) {
        this(model, id, name, icon, width, vis, true, clazz);
    }

    public String toString() {
        return this.messageId;
    }

    private void setHeaderVisible(boolean vis) {
        if (vis) {
            super.setHeaderRenderer(this.getHeaderSortRenderer());
            if (this.visName) {
                if (this.icon != null) {
                    super.setHeaderValue(this.icon);
                } else if (this.name != null) {
                    super.setHeaderValue(this.name);
                } else {
                    super.setHeaderValue("");
                }
            } else {
                super.setHeaderValue("");
            }
        } else {
            super.setHeaderRenderer(this.getInvisSortRenderer());
            super.setHeaderValue("");
        }
    }

    public boolean getDefaultVisibility() {
        return this.defaultVisibility;
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public int getDefaultOrder() {
        return this.getModelIndex();
    }

    public String getName() {
        return this.name;
    }

    public Icon getIcon() {
        return this.icon;
    }

    Class<?> getColumnClass() {
        return this.clazz;
    }

    public String getId() {
        return this.messageId;
    }

    @Override
    public void setModelIndex(int idx) {
        if (!this.initialized) {
            return;
        }
        throw new IllegalStateException("cannot change model index");
    }

    @Override
    public void setHeaderValue(Object val) {
        if (!this.initialized) {
            return;
        }
        throw new IllegalStateException("cannot change header value");
    }

    @Override
    public void setIdentifier(Object id) {
        if (!this.initialized) {
            return;
        }
        throw new IllegalStateException("cannot change id");
    }

    private TableCellRenderer getHeaderSortRenderer() {
        if (HEADER_RENDERER == null) {
            HEADER_RENDERER = new SortHeaderRenderer();
        }
        return HEADER_RENDERER;
    }

    private TableCellRenderer getInvisSortRenderer() {
        if (INVIS_RENDERER == null) {
            SortHeaderRenderer rnd = new SortHeaderRenderer();
            rnd.setAllowIcon();
            INVIS_RENDERER = rnd;
        }
        return INVIS_RENDERER;
    }
}

