/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.MultilineToolTip;
import com.limegroup.gnutella.gui.search.FWAbstractJPanelTableCellRenderer;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.JSortTable;
import com.limegroup.gnutella.gui.tables.LastColumnException;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.TableSettings;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Position;

public class LimeJTable
extends JTable
implements JSortTable {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static LimeTableColumn _lastRemoved;
    private final String[] CLIPPED_TIP = new String[1];
    private final Map<Object, LimeTableColumn> _hiddenColumns = new HashMap<Object, LimeTableColumn>();
    private int pressedColumnIndex = -1;
    private String[] tips;
    private ColumnPreferenceHandler columnPreferences;
    private TableSettings tableSettings;

    public LimeJTable(DataLineModel<?, ?> dm) {
        super(dm);
        this.setToolTipText("");
        GUIUtils.fixInputMap(this);
        this.addFocusListener(FocusHandler.INSTANCE);
        this.setupTableFont();
    }

    @Override
    public int getSelectedRow() {
        int selected = super.getSelectedRow();
        if (selected >= this.dataModel.getRowCount()) {
            return -1;
        }
        return selected;
    }

    public void setSelectedRow(int row) {
        this.clearSelection();
        this.addRowSelectionInterval(row, row);
    }

    @Override
    public int[] getSelectedRows() {
        int[] selected = super.getSelectedRows();
        if (selected == null || selected.length == 0) {
            return selected;
        }
        Arrays.sort(selected);
        int tableSize = this.dataModel.getRowCount();
        for (int i2 = 0; i2 < selected.length; ++i2) {
            if (selected[i2] < tableSize) continue;
            int[] newData = new int[i2];
            System.arraycopy(selected, 0, newData, 0, i2);
            return newData;
        }
        return selected;
    }

    public void ensureSelectionVisible() {
        this.ensureRowVisible(this.getSelectedRow());
    }

    public void ensureRowVisible(int row) {
        if (row != -1) {
            this.scrollRectToVisible(this.getCellRect(row, 0, true));
        }
    }

    boolean isSelectionVisible() {
        return this.isRowVisible(this.getSelectedRow());
    }

    public boolean isRowVisible(int row) {
        if (row == -1) {
            return false;
        }
        Rectangle cellRect = this.getCellRect(row, 0, false);
        return this.getVisibleRect().intersects(cellRect);
    }

    ColumnPreferenceHandler getColumnPreferenceHandler() {
        return this.columnPreferences;
    }

    void setColumnPreferenceHandler(ColumnPreferenceHandler handl) {
        this.columnPreferences = handl;
    }

    TableSettings getTableSettings() {
        return this.tableSettings;
    }

    void setTableSettings(TableSettings settings2) {
        this.tableSettings = settings2;
    }

    @Override
    public int getPressedColumnIndex() {
        return this.convertColumnIndexToView(this.pressedColumnIndex);
    }

    void setPressedColumnIndex(int col) {
        this.pressedColumnIndex = col;
    }

    @Override
    public int getSortedColumnIndex() {
        return this.convertColumnIndexToView(((DataLineModel)this.dataModel).getSortColumn());
    }

    @Override
    public boolean isSortedColumnAscending() {
        return ((DataLineModel)this.dataModel).isSortAscending();
    }

    void setColumnVisible(Object columnId, boolean visible) throws LastColumnException {
        if (!visible) {
            TableColumnModel model = this.getColumnModel();
            if (model.getColumnCount() == 1) {
                throw new LastColumnException();
            }
            LimeTableColumn column = (LimeTableColumn)model.getColumn(model.getColumnIndex(columnId));
            this._hiddenColumns.put(columnId, column);
            _lastRemoved = column;
            this.removeColumn(column);
        } else {
            TableColumn column = this._hiddenColumns.get(columnId);
            this._hiddenColumns.remove(columnId);
            this.addColumn(column);
        }
    }

    Iterator<LimeTableColumn> getHiddenColumns() {
        return Collections.unmodifiableCollection(this._hiddenColumns.values()).iterator();
    }

    LimeTableColumn getLastRemovedColumn() {
        return _lastRemoved;
    }

    public boolean isColumnVisible(Object columnId) {
        return !this._hiddenColumns.containsKey(columnId);
    }

    public boolean isPointSelected(Point p) {
        int[] sel;
        int row = this.rowAtPoint(p);
        int col = this.columnAtPoint(p);
        if (row == -1 || col == -1) {
            return false;
        }
        for (int aSel : sel = this.getSelectedRows()) {
            if (aSel != row) continue;
            return true;
        }
        return false;
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        try {
            int index;
            TableModel model;
            int reselectIndex = -1;
            if (OSUtils.isAnyMac() && e.isControlDown() && (model = this.getModel()) != null && this.isRowSelected(index = this.rowAtPoint(e.getPoint()))) {
                reselectIndex = index;
            }
            super.processMouseEvent(e);
            if (reselectIndex != -1) {
                this.getSelectionModel().addSelectionInterval(reselectIndex, reselectIndex);
            }
            if (e.getID() == 500 && SwingUtilities.isLeftMouseButton(e) && !e.isPopupTrigger() && (model = this.getModel()) != null && ((index = this.rowAtPoint(e.getPoint())) < 0 || index >= model.getRowCount())) {
                this.clearSelection();
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            String msg = aioobe.getMessage();
            if (msg != null && msg.contains("at javax.swing.MenuSelectionManager.processMouseEvent")) {
                return;
            }
            throw aioobe;
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        boolean forceTooltip;
        FWAbstractJPanelTableCellRenderer renderer;
        String tooltip;
        int col;
        Point p = e.getPoint();
        int row = this.rowAtPoint(p);
        TableCellRenderer cellRenderer = this.getCellRenderer(row, col = this.columnAtPoint(p));
        if (cellRenderer instanceof FWAbstractJPanelTableCellRenderer && (tooltip = (renderer = (FWAbstractJPanelTableCellRenderer)cellRenderer).getToolTipText(e)) != null) {
            this.tips = new String[]{tooltip};
            return tooltip;
        }
        int colModel = this.convertColumnIndexToModel(col);
        DataLineModel dlm = (DataLineModel)this.dataModel;
        boolean isClippable = col > -1 && row > -1 && dlm.isClippable(colModel);
        boolean bl = forceTooltip = col > -1 && row > -1 && dlm.isTooltipRequired(row, col);
        if (!this.tableSettings.DISPLAY_TOOLTIPS.getValue() && !forceTooltip) {
            if (isClippable) {
                return this.clippedToolTip(row, col, colModel);
            }
            return null;
        }
        if (row > -1) {
            this.tips = dlm.getToolTipArray(row, colModel);
            if (this.tips == null) {
                if (isClippable) {
                    return this.clippedToolTip(row, col, colModel);
                }
                return null;
            }
            return dlm.get(row).toString() + col;
        }
        this.tips = EMPTY_STRING_ARRAY;
        return null;
    }

    private String clippedToolTip(int row, int col, int colModel) {
        int dataWidth;
        TableColumn tc = this.getColumnModel().getColumn(col);
        int columnWidth = tc.getWidth();
        if (columnWidth < (dataWidth = this.getDataWidth(row, colModel))) {
            this.tips = this.CLIPPED_TIP;
            this.stripHTMLFromTips();
            return ((DataLineModel)this.dataModel).get(row).toString() + col;
        }
        this.tips = EMPTY_STRING_ARRAY;
        return null;
    }

    private void stripHTMLFromTips() {
        if (this.tips == null || this.tips.length == 0) {
            return;
        }
        int i2 = 0;
        for (String s : this.tips) {
            this.tips[i2++] = this.stripHTML(s);
        }
    }

    private String stripHTML(String html) {
        String clean = html.replaceAll("\\<.*?>", "");
        clean = clean.replaceAll("&nbsp;", "");
        clean = clean.replaceAll("&amp;", "&");
        return clean;
    }

    private int getDataWidth(int row, int col) {
        String info;
        DataLineModel dlm = (DataLineModel)this.dataModel;
        Object dl = dlm.get(row);
        Object data = dl.getValueAt(col);
        if (data != null && (info = data.toString()) != null) {
            if (data instanceof Icon && info.startsWith("file:")) {
                return -1;
            }
            this.CLIPPED_TIP[0] = info;
            TableCellRenderer tcr = this.getDefaultRenderer(dlm.getColumnClass(col));
            JComponent renderer = (JComponent)tcr.getTableCellRendererComponent(this, data, false, false, row, col);
            try {
                FontMetrics fm = renderer.getFontMetrics(renderer.getFont());
                return fm.stringWidth(info) + 3;
            }
            catch (NullPointerException npe) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public JToolTip createToolTip() {
        MultilineToolTip ret = new MultilineToolTip();
        if (this.tips != null && this.tips.length > 0) {
            ret.setTipArray(this.tips);
        }
        this.tips = EMPTY_STRING_ARRAY;
        return ret;
    }

    @Override
    public void createDefaultColumnsFromModel() {
        DataLineModel dlm = (DataLineModel)this.dataModel;
        if (dlm != null) {
            TableColumnModel cm = this.getColumnModel();
            while (cm.getColumnCount() > 0) {
                cm.removeColumn(cm.getColumn(0));
            }
            for (int i2 = 0; i2 < dlm.getColumnCount(); ++i2) {
                LimeTableColumn newColumn = dlm.getTableColumn(i2);
                if (newColumn == null) continue;
                this.addColumn(newColumn);
            }
        }
    }

    int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
        DataLineModel model = (DataLineModel)this.dataModel;
        int max = model.getRowCount();
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (startIndex < 0 || startIndex >= max) {
            throw new IllegalArgumentException();
        }
        prefix = prefix.toUpperCase();
        int increment = bias == Position.Bias.Forward ? 1 : -1;
        int index = startIndex;
        int typeAheadColumn = model.getTypeAheadColumn();
        if (typeAheadColumn >= 0 && typeAheadColumn < model.getColumnCount()) {
            do {
                String string;
                Object o;
                if ((o = model.getValueAt(index, typeAheadColumn)) == null) continue;
                if (o instanceof String) {
                    string = ((String)o).toUpperCase();
                } else {
                    string = o.toString();
                    if (string != null) {
                        string = string.toUpperCase();
                    }
                }
                if (string == null || !string.startsWith(prefix)) continue;
                return index;
            } while ((index = (index + increment + max) % max) != startIndex);
        }
        return -1;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            return parent.getHeight() > this.getPreferredSize().height;
        }
        return super.getScrollableTracksViewportHeight();
    }

    @Override
    public void paint(Graphics g) {
        Border rowBorder;
        try {
            super.paint(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int focusedRow = this.getFocusedRow(true);
        if (focusedRow != -1 && focusedRow < this.getRowCount() && (rowBorder = UIManager.getBorder("Table.focusRowHighlightBorder")) != null) {
            Rectangle rect = this.getCellRect(focusedRow, 0, true);
            rect.width = this.getWidth();
            rowBorder.paintBorder(this, g, rect.x, rect.y, rect.width, rect.height);
        }
    }

    protected boolean isOverrideRowColor(int row) {
        return false;
    }

    private void repaintFocusedRow() {
        int focusedRow = this.getFocusedRow(false);
        if (focusedRow != -1 && focusedRow < this.getRowCount()) {
            Rectangle rect = this.getCellRect(focusedRow, 0, true);
            rect.width = this.getWidth();
            this.repaint(rect);
        }
    }

    private int getFocusedRow(boolean requireFocus) {
        if (!requireFocus || this.hasFocus()) {
            return this.selectionModel.getAnchorSelectionIndex();
        }
        return -1;
    }

    private void setupTableFont() {
        Font f = ThemeMediator.getCurrentTableFont();
        UIDefaults nimbusOverrides = new UIDefaults();
        nimbusOverrides.put("Table.font", new FontUIResource(f));
        this.putClientProperty("Nimbus.Overrides", nimbusOverrides);
        FontMetrics fm = this.getFontMetrics(f);
        int h = fm.getHeight() + 8;
        this.setRowHeight(h);
    }

    private static class FocusHandler
    implements FocusListener {
        private static final FocusListener INSTANCE = new FocusHandler();

        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            LimeJTable t = (LimeJTable)e.getSource();
            t.repaintFocusedRow();
        }

        @Override
        public void focusLost(FocusEvent e) {
            LimeJTable t = (LimeJTable)e.getSource();
            t.repaintFocusedRow();
        }
    }
}

