/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.MouseObserver;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;

public final class DefaultMouseListener
implements MouseListener {
    private final MouseObserver cm;

    public DefaultMouseListener(MouseObserver mo) {
        this.cm = mo;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.tryPopup(event)) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(event)) {
            this.cm.handleRightMouseClick(event);
        } else if (event.getClickCount() >= 2) {
            this.cm.handleMouseDoubleClick();
        } else {
            this.cm.handleMouseClick(event);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.tryPopup(event);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.tryPopup(event);
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    private boolean tryPopup(MouseEvent ev) {
        if (ev.isPopupTrigger()) {
            this.cm.handlePopupMenu(ev);
            return true;
        }
        return false;
    }
}

