/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.shell;

import com.limegroup.gnutella.gui.shell.ShellAssociation;
import com.limegroup.gnutella.gui.shell.WindowsMagnetHandlerAssociation;
import com.limegroup.gnutella.gui.shell.WindowsProtocolShellAssociation;

class MagnetAssociation
implements ShellAssociation {
    private static final String MAGNET_EXTENSION = "magnet";
    private static final String MAGNET_PROTOCOL = "Magnet Protocol";
    private final ShellAssociation protocol;
    private final ShellAssociation handler;

    MagnetAssociation(String program, String executable) {
        this.protocol = new WindowsProtocolShellAssociation(executable, MAGNET_EXTENSION, MAGNET_PROTOCOL);
        this.handler = new WindowsMagnetHandlerAssociation(program, executable);
    }

    @Override
    public boolean isAvailable() {
        return this.protocol.isAvailable();
    }

    @Override
    public boolean isRegistered() {
        return this.protocol.isRegistered();
    }

    @Override
    public void register() {
        this.protocol.register();
        this.handler.register();
    }

    @Override
    public void unregister() {
        this.protocol.unregister();
        if (this.handler.isRegistered()) {
            this.handler.unregister();
        }
    }
}

