/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.CancelSearchIconProxy;
import com.limegroup.gnutella.gui.search.SearchMediator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;

final class SearchTabbedPane
extends JTabbedPane {
    SearchTabbedPane() {
    }

    @Override
    public void addTab(String title, Icon icon, Component component) {
        super.addTab(title, icon, component);
        int tabIndex = this.getTabCount() - 1;
        this.setTabComponentAt(tabIndex, new SearchTabHeader(component, title));
    }

    @Override
    public void setTitleAt(int index, String title) {
        Component c = this.getTabComponentAt(index);
        if (c instanceof SearchTabHeader) {
            ((SearchTabHeader)c).setTitle(title);
        }
    }

    void setProgressActiveAt(int index, boolean active) {
        Component c = this.getTabComponentAt(index);
        if (c instanceof SearchTabHeader) {
            ((SearchTabHeader)c).setProgressActive(active);
        }
    }

    void switchToTabByOffset(int offset) {
        int oldIndex = this.getSelectedIndex() < 0 ? 0 : this.getSelectedIndex();
        int newIndex = (oldIndex + offset) % this.getTabCount();
        if (newIndex < 0) {
            newIndex += this.getTabCount();
        }
        this.setSelectedIndex(newIndex);
    }

    private final class SearchTabHeader
    extends JPanel {
        private final Component component;
        private final JLabel labelText;

        SearchTabHeader(Component component, String text) {
            this.component = component;
            this.setLayout(new MigLayout("insets 0, gap 0"));
            JButton buttonClose = new JButton(CancelSearchIconProxy.createSelected());
            buttonClose.setOpaque(false);
            buttonClose.setContentAreaFilled(false);
            buttonClose.setBorderPainted(false);
            buttonClose.addActionListener(new CloseActionHandler());
            this.add((Component)buttonClose, "h 17!, w 23!");
            this.labelText = new JLabel(text.trim());
            this.labelText.setHorizontalTextPosition(10);
            this.labelText.setAlignmentX(4.0f);
            this.labelText.setIcon(GUIMediator.getThemeImage("indeterminate_small_progress"));
            this.add(this.labelText);
        }

        void setTitle(String title) {
            this.labelText.setText(title);
        }

        void setProgressActive(boolean active) {
            if (active) {
                this.labelText.setIcon(GUIMediator.getThemeImage("indeterminate_small_progress"));
            } else {
                this.labelText.setIcon(null);
            }
        }

        class CloseActionHandler
        implements ActionListener {
            CloseActionHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = SearchMediator.getSearchResultDisplayer().getIndexForTabComponent(SearchTabHeader.this.component);
                if (index != -1) {
                    SearchMediator.getSearchResultDisplayer().killSearchAtIndex(index);
                }
            }
        }
    }
}

