/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.UISearchResult;
import com.limegroup.gnutella.gui.tables.NameHolder;
import java.util.HashSet;

final class SearchResultNameHolder
extends NameHolder {
    private final String displayName;

    SearchResultNameHolder(UISearchResult sr) {
        super(SearchResultNameHolder.buildHTMLString(sr));
        this.displayName = sr.getDisplayName();
    }

    private static String buildHTMLString(UISearchResult sr) {
        return "<html><div width=\"1000000px\">" + SearchResultNameHolder.simpleHighlighter(sr.getQuery(), sr.getDisplayName()) + "</div></html>";
    }

    private static String simpleHighlighter(String query, String str) {
        if (query == null || query.isEmpty()) {
            return str;
        }
        String[] rawTokens = query.split("\\s+");
        HashSet<String> uniqueTokens = new HashSet<String>();
        for (String token : rawTokens) {
            uniqueTokens.add(token.trim());
        }
        for (String token : uniqueTokens) {
            int offset = 0;
            int regionEnd = offset + token.length();
            while (regionEnd < ((String)str).length()) {
                if (((String)str).regionMatches(true, offset, token, 0, token.length())) {
                    String tokenAsFoundInStr = ((String)str).substring(offset, offset + token.length());
                    str = ((String)str).substring(0, offset) + "<b>" + tokenAsFoundInStr + "</b>" + ((String)str).substring(offset + token.length());
                    offset += token.length() + 7;
                } else {
                    ++offset;
                }
                regionEnd = offset + token.length();
            }
        }
        return str;
    }

    @Override
    public String toString() {
        return this.displayName;
    }
}

