/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.components.slides.MultimediaSlideshowPanel;
import com.frostwire.gui.components.slides.Slide;
import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.search.CancelSearchIconProxy;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.search.SearchTabbedPane;
import com.limegroup.gnutella.gui.search.UISearchResult;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.settings.UpdateManagerSettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;

public final class SearchResultDisplayer
implements RefreshListener {
    private static final List<SearchResultMediator> entries = new ArrayList<SearchResultMediator>();
    private static final int MIN_HEIGHT = 220;
    private final PaneListener PANE_LISTENER = new PaneListener();
    private final JPanel MAIN_PANEL;
    private SearchTabbedPane tabbedPane;
    private final JPanel results;
    private final CardLayout cardLayoutSwitcher = new CardLayout();
    private ChangeListener _activeSearchListener;
    private MultimediaSlideshowPanel promoSlides;

    SearchResultDisplayer() {
        this.MAIN_PANEL = new BoxPanel(1);
        this.MAIN_PANEL.setMinimumSize(new Dimension(0, 0));
        this.tabbedPane = new SearchTabbedPane();
        this.results = new JPanel();
        this.results.setPreferredSize(new Dimension(10000, 10000));
        this.results.setLayout(this.cardLayoutSwitcher);
        this.promoSlides = null;
        this.promoSlides = !UpdateManagerSettings.SHOW_PROMOTION_OVERLAYS.getValue() ? new MultimediaSlideshowPanel(this.getDefaultSlides()) : new MultimediaSlideshowPanel(UpdateManagerSettings.OVERLAY_SLIDESHOW_JSON_URL.getValue(), this.getDefaultSlides());
        Dimension promoDimensions = new Dimension(717, 380);
        this.promoSlides.setPreferredSize(promoDimensions);
        this.promoSlides.setSize(promoDimensions);
        this.promoSlides.setMaximumSize(promoDimensions);
        SearchResultMediator DUMMY = new SearchResultMediator(this.promoSlides);
        JPanel mainScreen = new JPanel(new BorderLayout());
        this.promoSlides.setupContainerAndControls(mainScreen, true);
        mainScreen.add((Component)DUMMY.getComponent(), "Center");
        this.results.add("dummy", mainScreen);
        this.cardLayoutSwitcher.first(this.results);
        this.setupTabbedPane();
        this.MAIN_PANEL.add(this.results);
        CancelSearchIconProxy.updateTheme();
    }

    public void switchToTabByOffset(int offset) {
        if (this.tabbedPane != null) {
            this.tabbedPane.switchToTabByOffset(offset);
        }
    }

    private List<Slide> getDefaultSlides() {
        if (!OSUtils.isWindowsAppStoreInstall()) {
            Slide s1 = new Slide("https://static.frostwire.com/images/overlays/default_now_on_android.png", "https://www.frostwire.com/?from=defaultSlide", 240000L, null, null, null, null, null, null, 0L, 0, null, null, null, null, null, null, null, null, null, 512);
            Slide s2 = new Slide("https://static.frostwire.com/images/overlays/frostclick_default_overlay.jpg", "https://www.frostclick.com/?from=defaultSlide", 240000L, null, null, null, null, null, null, 0L, 0, null, null, null, null, null, null, null, null, null, 512);
            return Arrays.asList(s1, s2);
        }
        return Collections.singletonList(new Slide("https://static.frostwire.com/images/overlays/frostclick_default_overlay.jpg", "https://www.frostclick.com/?from=defaultSlide", 240000L, null, null, null, null, null, null, 0L, 0, null, null, null, null, null, null, null, null, null, 512));
    }

    void setSearchListener(ChangeListener listener) {
        this._activeSearchListener = listener;
    }

    SearchResultMediator addResultTab(long token, List<String> searchTokens, SearchInformation info) {
        SearchResultMediator searchResultMediator = new SearchResultMediator(token, searchTokens, info);
        if (this.MAIN_PANEL.getHeight() < 220) {
            GUIMediator.instance().getMainFrame().resizeSearchTransferDivider(220);
        }
        return this.addResultPanelInternal(searchResultMediator, info.getTitle());
    }

    private void removeTabbedPaneListeners() {
        if (this.tabbedPane != null) {
            this.tabbedPane.removeMouseListener(this.PANE_LISTENER);
            this.tabbedPane.removeMouseMotionListener(this.PANE_LISTENER);
            this.tabbedPane.removeChangeListener(this.PANE_LISTENER);
        }
    }

    private void addTabbedPaneListeners() {
        if (this.tabbedPane != null) {
            this.tabbedPane.addMouseListener(this.PANE_LISTENER);
            this.tabbedPane.addMouseMotionListener(this.PANE_LISTENER);
            this.tabbedPane.addChangeListener(this.PANE_LISTENER);
        }
    }

    private void setupTabbedPane() {
        this.removeTabbedPaneListeners();
        this.tabbedPane = new SearchTabbedPane();
        this.tabbedPane.setRequestFocusEnabled(false);
        this.results.add("tabbedPane", this.tabbedPane);
        this.addTabbedPaneListeners();
    }

    private void resetTabbedPane() {
        int i2;
        ArrayList<SearchResultMediator> ents = new ArrayList<SearchResultMediator>();
        ArrayList<Component> tabs = new ArrayList<Component>();
        ArrayList<String> titles = new ArrayList<String>();
        for (i2 = 0; i2 < this.tabbedPane.getTabCount() && i2 < entries.size(); ++i2) {
            tabs.add(this.tabbedPane.getComponent(i2));
            titles.add(this.tabbedPane.getTitleAt(i2));
            ents.add(entries.get(i2));
        }
        this.tabbedPane.removeAll();
        entries.clear();
        this.setupTabbedPane();
        for (i2 = 0; i2 < tabs.size(); ++i2) {
            entries.add((SearchResultMediator)ents.get(i2));
            this.tabbedPane.addTab((String)titles.get(i2), (Component)tabs.get(i2));
        }
    }

    private SearchResultMediator addResultPanelInternal(SearchResultMediator searchResultMediator, String title) {
        entries.add(searchResultMediator);
        try {
            this.tabbedPane.addTab(title, CancelSearchIconProxy.createSelected(), searchResultMediator.getComponent());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.resetTabbedPane();
            entries.add(searchResultMediator);
            this.tabbedPane.addTab(title, CancelSearchIconProxy.createSelected(), searchResultMediator.getComponent());
        }
        try {
            this.tabbedPane.setSelectedIndex(entries.size() - 1);
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.resetTabbedPane();
            this.tabbedPane.setSelectedIndex(entries.size() - 1);
        }
        try {
            this.tabbedPane.setProgressActiveAt(entries.size() - 1, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (SearchSettings.PARALLEL_SEARCH.getValue() > 10) {
            SearchSettings.PARALLEL_SEARCH.revertToDefault();
        }
        if (entries.size() > SearchSettings.PARALLEL_SEARCH.getValue()) {
            this.killSearchAtIndex(0);
        }
        this.promoSlides.setVisible(false);
        this.cardLayoutSwitcher.last(this.results);
        this.MAIN_PANEL.revalidate();
        return searchResultMediator;
    }

    void addQueryResult(long token, UISearchResult line, SearchResultMediator rp) {
        boolean isTellurideSearch;
        boolean bl = isTellurideSearch = line.getSearchEngine().getId() == SearchEngine.SearchEngineID.TELLURIDE_ID;
        if (!isTellurideSearch && rp.isStopped()) {
            return;
        }
        if (!rp.matches(token)) {
            throw new IllegalArgumentException("guids don't match");
        }
        rp.add(line);
        int resultPanelIndex = entries.indexOf(rp);
        if (resultPanelIndex == -1) {
            return;
        }
        this.tabbedPane.setTitleAt(resultPanelIndex, this.titleOf(rp));
    }

    void updateSearchIcon(SearchResultMediator rp, boolean active) {
        int resultPanelIndex = entries.indexOf(rp);
        if (resultPanelIndex == -1) {
            return;
        }
        this.tabbedPane.setProgressActiveAt(resultPanelIndex, active);
    }

    public void updateSearchTitle(SearchResultMediator rp, String title) {
        int resultPanelIndex = entries.indexOf(rp);
        if (resultPanelIndex == -1) {
            return;
        }
        this.tabbedPane.setTitleAt(resultPanelIndex, title);
    }

    private void showMenu(MouseEvent e) {
        SearchResultMediator rp = this.getSelectedResultPanel();
        if (rp != null) {
            JPopupMenu menu = rp.createPopupMenu(new SearchResultDataLine[0]);
            Point p = e.getPoint();
            if (menu != null) {
                try {
                    menu.show(this.MAIN_PANEL, p.x + 1, p.y - 6);
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
            }
        }
    }

    SearchResultMediator getSelectedResultPanel() {
        int i2 = this.tabbedPane.getSelectedIndex();
        if (i2 == -1) {
            return null;
        }
        try {
            return entries.get(i2);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public SearchResultMediator getResultPanelForGUID(long token) {
        for (SearchResultMediator rp : entries) {
            if (!rp.matches(token)) continue;
            return rp;
        }
        return null;
    }

    private int getIndexForPoint(int x, int y) {
        TabbedPaneUI ui = this.tabbedPane.getUI();
        return ui.tabForCoordinate(this.tabbedPane, x, y);
    }

    int getIndexForTabComponent(Component c) {
        for (int i2 = 0; i2 < entries.size(); ++i2) {
            SearchResultMediator rp = entries.get(i2);
            if (!rp.getComponent().equals(c)) continue;
            return i2;
        }
        return -1;
    }

    public void closeCurrentTab() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index != -1) {
            this.killSearchAtIndex(index);
        }
    }

    void closeTabAt(int i2) {
        try {
            SearchResultMediator searchResultMediator = entries.get(i2);
            if (searchResultMediator != null) {
                this.killSearchAtIndex(i2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void closeAllTabs() {
        while (entries.size() > 0) {
            this.closeTabAt(0);
        }
    }

    void closeOtherTabs() {
        if (entries.size() < 2) {
            return;
        }
        int index = this.tabbedPane.getSelectedIndex();
        if (index != -1) {
            SearchResultMediator currentMediator = entries.get(index);
            int i2 = 0;
            while (entries.size() > 1 && i2 < entries.size()) {
                if (entries.get(i2) != currentMediator) {
                    this.closeTabAt(i2);
                    continue;
                }
                ++i2;
            }
        }
    }

    void killSearchAtIndex(int i2) {
        SearchResultMediator killed = entries.remove(i2);
        try {
            this.tabbedPane.removeTabAt(i2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ArrayIndexOutOfBoundsException oob) {
            this.resetTabbedPane();
            this.tabbedPane.removeTabAt(i2);
        }
        this.fixIcons();
        SearchMediator.searchKilled(killed);
        if (entries.size() == 0) {
            try {
                this.promoSlides.setVisible(true);
                this.cardLayoutSwitcher.first(this.results);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    void setTabDisplayCount(SearchResultMediator rp) {
        int i2;
        boolean found = false;
        for (i2 = 0; i2 < entries.size(); ++i2) {
            SearchResultMediator panel = entries.get(i2);
            if (panel != rp) continue;
            found = true;
            break;
        }
        if (found) {
            this.tabbedPane.setTitleAt(i2, this.titleOf(rp));
        }
    }

    private void fixIcons() {
        int sel = this.tabbedPane.getSelectedIndex();
        for (int i2 = 0; i2 < entries.size() && i2 < this.tabbedPane.getTabCount(); ++i2) {
            this.tabbedPane.setIconAt(i2, i2 == sel ? CancelSearchIconProxy.createSelected() : CancelSearchIconProxy.createPlain());
        }
    }

    JComponent getComponent() {
        return this.MAIN_PANEL;
    }

    @Override
    public void refresh() {
        if (this.tabbedPane.isVisible() && this.tabbedPane.isShowing()) {
            Component comp;
            Rectangle allBounds = this.tabbedPane.getBounds();
            try {
                comp = this.tabbedPane.getSelectedComponent();
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                this.resetTabbedPane();
                comp = this.tabbedPane.getSelectedComponent();
            }
            if (comp != null) {
                Rectangle compBounds = comp.getBounds();
                Rectangle allTabs = new Rectangle(allBounds.x, allBounds.y, allBounds.width, compBounds.y - 1);
                this.tabbedPane.repaint(allTabs);
            }
        }
    }

    private String titleOf(SearchResultMediator rp) {
        int total = rp.totalResults();
        Object title = rp.getTitle();
        if (((String)title).length() > 40) {
            title = ((String)title).substring(0, 39) + "...";
        }
        return (String)title + " (" + total + " " + I18n.tr("results") + ")";
    }

    int tabCount() {
        int result = 0;
        if (!entries.isEmpty()) {
            result = entries.size();
        }
        return result;
    }

    int currentTabIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    private class PaneListener
    extends MouseAdapter
    implements MouseListener,
    MouseMotionListener,
    ChangeListener {
        private int lastIdx = -1;

        private PaneListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.tryPopup(e)) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(e)) {
                int y;
                int x = e.getX();
                int idx = this.shouldKillIndex(x, y = e.getY());
                if (idx != -1) {
                    this.lastIdx = -1;
                    SearchResultDisplayer.this.killSearchAtIndex(idx);
                }
                if (idx == -1) {
                    this.stateChanged(null);
                }
            }
        }

        private int shouldKillIndex(int x, int y) {
            Icon icon;
            int idx = SearchResultDisplayer.this.getIndexForPoint(x, y);
            if (idx != -1 && (icon = SearchResultDisplayer.this.tabbedPane.getIconAt(idx)) instanceof CancelSearchIconProxy && ((CancelSearchIconProxy)icon).shouldKill(x, y)) {
                return idx;
            }
            return -1;
        }

        private void resetIcon() {
            if (this.lastIdx != -1 && this.lastIdx < SearchResultDisplayer.this.tabbedPane.getTabCount()) {
                if (this.lastIdx == SearchResultDisplayer.this.tabbedPane.getSelectedIndex()) {
                    SearchResultDisplayer.this.tabbedPane.setIconAt(this.lastIdx, CancelSearchIconProxy.createSelected());
                } else {
                    SearchResultDisplayer.this.tabbedPane.setIconAt(this.lastIdx, CancelSearchIconProxy.createPlain());
                }
                this.lastIdx = -1;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.tryPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.tryPopup(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.resetIcon();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        private boolean tryPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int idx = SearchResultDisplayer.this.getIndexForPoint(e.getX(), e.getY());
                if (idx != -1) {
                    try {
                        SearchResultDisplayer.this.tabbedPane.setSelectedIndex(idx);
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        SearchResultDisplayer.this.resetTabbedPane();
                        SearchResultDisplayer.this.tabbedPane.setSelectedIndex(idx);
                    }
                }
                SearchResultDisplayer.this.showMenu(e);
                return true;
            }
            return false;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SearchResultDisplayer.this._activeSearchListener.stateChanged(e);
            SearchResultDisplayer.this.fixIcons();
        }
    }
}

