/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledTextField;
import com.limegroup.gnutella.gui.search.GeneralResultFilter;
import com.limegroup.gnutella.gui.search.LabeledRangeSlider;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.gui.search.SearchEngineFilter;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.limewire.setting.BooleanSetting;

final class SearchOptionsPanel
extends JPanel {
    private final SearchResultMediator resultPanel;
    private final LabeledTextField textFieldKeywords;
    private final LabeledRangeSlider sliderSize;
    private final LabeledRangeSlider sliderSeeds;
    private final Map<SearchEngine, JCheckBox> engineCheckboxes;
    private GeneralResultFilter generalFilter;

    public SearchOptionsPanel(SearchResultMediator resultPanel) {
        this.resultPanel = resultPanel;
        this.engineCheckboxes = new HashMap<SearchEngine, JCheckBox>();
        this.setLayout(new MigLayout("insets 0, fillx"));
        this.textFieldKeywords = this.createNameFilter();
        this.add((Component)this.textFieldKeywords, "gapx 3, gaptop 4px, wrap");
        this.add((Component)new JSeparator(0), "growx, wrap");
        this.add((Component)this.createSearchEnginesFilter(), "wrap");
        this.add((Component)new JSeparator(0), "growx, wrap");
        this.sliderSize = this.createSizeFilter();
        this.add((Component)this.sliderSize, "gapx 3, wrap");
        this.add((Component)new JSeparator(0), "growx, wrap");
        this.sliderSeeds = this.createSeedsFilter();
        this.add((Component)this.sliderSeeds, "gapx 3, wrap");
        this.add((Component)new JSeparator(0), "growx, wrap");
        this.resetFilters();
    }

    void onOptionsPanelShown() {
        this.textFieldKeywords.requestFocus();
    }

    void updateFiltersPanel() {
        this.generalFilter = new GeneralResultFilter(this.resultPanel, this.sliderSeeds, this.sliderSize);
        this.updateCheckboxes(SearchEngine.getEngines());
        this.resultPanel.filterChanged(new SearchEngineFilter(this.engineCheckboxes), 0);
        this.resultPanel.filterChanged(this.generalFilter, 1);
    }

    private void updateCheckboxes(List<SearchEngine> engines) {
        for (SearchEngine se : engines) {
            JCheckBox cBox = this.engineCheckboxes.get(se);
            if (cBox == null || cBox.isEnabled() && !cBox.isSelected() && se.isEnabled()) continue;
            cBox.setSelected(se.isEnabled());
            cBox.setEnabled(se.isEnabled());
        }
    }

    void resetFilters() {
        this.sliderSeeds.setMinimum(0);
        this.sliderSeeds.setMaximum(1000);
        this.sliderSeeds.setLowerValue(0);
        this.sliderSeeds.setUpperValue(1000);
        this.sliderSize.setMinimum(0);
        this.sliderSize.setMaximum(1000);
        this.sliderSize.setLowerValue(0);
        this.sliderSize.setUpperValue(1000);
        this.sliderSeeds.getMinimumValueLabel().setText("0");
        this.sliderSeeds.getMaximumValueLabel().setText(I18n.tr("Max"));
        this.sliderSize.getMinimumValueLabel().setText("0");
        this.sliderSize.getMaximumValueLabel().setText(I18n.tr("Max"));
        this.textFieldKeywords.setText("");
    }

    private JComponent createSearchEnginesFilter() {
        JPanel panel = new JPanel();
        panel.setLayout(new MigLayout("insets 3, wrap 2"));
        List<SearchEngine> searchEngines = SearchEngine.getEngines();
        this.setupCheckboxes(searchEngines, panel);
        return panel;
    }

    private LabeledTextField createNameFilter() {
        LabeledTextField textField = new LabeledTextField(I18n.tr("Name|Source|Ext."), 80, -1, 240);
        textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SearchOptionsPanel.this.textFieldKeywords_keyReleased();
            }
        });
        return textField;
    }

    private LabeledRangeSlider createSizeFilter() {
        LabeledRangeSlider slider = new LabeledRangeSlider(I18n.tr("Size"), null, 0, 1000);
        slider.setPreferredSize(new Dimension(240, (int)slider.getPreferredSize().getHeight()));
        slider.addChangeListener(e -> this.sliderSize_stateChanged());
        return slider;
    }

    private LabeledRangeSlider createSeedsFilter() {
        LabeledRangeSlider slider = new LabeledRangeSlider(I18n.tr("Seeds"), null, 0, 1000);
        slider.setPreferredSize(new Dimension(240, (int)slider.getPreferredSize().getHeight()));
        slider.addChangeListener(e -> this.sliderSeeds_stateChanged());
        return slider;
    }

    private void setupCheckboxes(List<SearchEngine> searchEngines, JPanel parent) {
        HashMap<JCheckBox, BooleanSetting> cBoxes = new HashMap<JCheckBox, BooleanSetting>();
        ItemListener listener = e -> {
            if (this.areAll(false)) {
                ((JCheckBox)e.getItemSelectable()).setSelected(true);
            }
            if (this.resultPanel != null) {
                this.resultPanel.filterChanged(new SearchEngineFilter(this.engineCheckboxes), 0);
            }
        };
        for (SearchEngine se : searchEngines) {
            JCheckBox cBox = new JCheckBox(se.getName());
            cBox.setSelected(se.isEnabled());
            cBox.setEnabled(se.isEnabled());
            if (!cBox.isEnabled()) {
                cBox.setToolTipText(se.getName() + " " + I18n.tr("has been disabled on your FrostWire Search Options. (Go to Tools > Options > Search to enable)"));
            }
            parent.add(cBox);
            cBoxes.put(cBox, se.getEnabledSetting());
            cBox.addItemListener(listener);
            this.engineCheckboxes.put(se, cBox);
        }
    }

    private boolean areAll(boolean selected) {
        Set<Map.Entry<SearchEngine, JCheckBox>> entries = this.engineCheckboxes.entrySet();
        for (Map.Entry<SearchEngine, JCheckBox> entry2 : entries) {
            JCheckBox cBox = entry2.getValue();
            if ((!selected || cBox.isSelected()) && (selected || !cBox.isSelected())) continue;
            return false;
        }
        return true;
    }

    private void textFieldKeywords_keyReleased() {
        if (this.generalFilter != null) {
            this.generalFilter.updateKeywordFiltering(this.textFieldKeywords.getText());
        }
    }

    private void sliderSize_stateChanged() {
        if (this.generalFilter != null) {
            this.generalFilter.setRangeSize(this.sliderSize.getLowerValue(), this.sliderSize.getUpperValue());
        }
    }

    private void sliderSeeds_stateChanged() {
        if (this.generalFilter != null) {
            this.generalFilter.setRangeSeeds(this.sliderSeeds.getLowerValue(), this.sliderSeeds.getUpperValue());
        }
    }
}

