/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.concurrent.concurrent.ExecutorsHelper;
import com.frostwire.gui.tabs.TransfersTab;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.MagnetOptions;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.util.QueryUtils;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.ExecutorService;

public class MagnetClipboardListener
extends WindowAdapter {
    private static final Logger LOG = Logger.getLogger(MagnetClipboardListener.class);
    private static final MagnetClipboardListener instance = new MagnetClipboardListener();
    private static final Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
    private final StringSelection empty = new StringSelection("");
    private final ExecutorService clipboardParser = ExecutorsHelper.newProcessingQueue("clipboard parser");
    private volatile String copiedText;
    private final Runnable parser = this::parseAndLaunch;

    private MagnetClipboardListener() {
    }

    public static MagnetClipboardListener getInstance() {
        return instance;
    }

    public static void handleMagnets(MagnetOptions[] magnets) {
        Runnable r = () -> {
            boolean oneSearchStarted = false;
            for (MagnetOptions magnet : magnets) {
                String query;
                SearchInformation info;
                if (magnet.isDownloadable() || !magnet.isKeywordTopicOnly() || oneSearchStarted || SearchMediator.validateInfo(info = SearchInformation.createKeywordSearch(query = QueryUtils.createQueryString(magnet.getKeywordTopic()), null, MediaType.getAnyTypeMediaType())) != 0) continue;
                oneSearchStarted = true;
                SearchMediator.instance().triggerSearch(info);
            }
            GUIMediator.instance().showTransfers(TransfersTab.FilterMode.DOWNLOADING);
        };
        GUIMediator.safeInvokeLater(r);
    }

    public static String getMagnetOrTorrentURLFromClipboard() {
        try {
            String clipboardText = GUIUtils.extractStringContentFromClipboard(CLIPBOARD);
            if (clipboardText == null) {
                return "";
            }
            if (clipboardText.contains("\n")) {
                clipboardText = clipboardText.split("\n")[0].trim();
            }
            if (clipboardText.startsWith("magnet:?xt=urn:btih:") || clipboardText.matches("^http.*\\.torrent$") || clipboardText.matches(".*soundcloud.com.*")) {
                return clipboardText;
            }
        }
        catch (Throwable e) {
            LOG.error("Error processing clipboard text", e);
        }
        return null;
    }

    private void parseAndLaunch() {
        String contents = GUIUtils.extractStringContentFromClipboard(CLIPBOARD);
        if (contents == null) {
            return;
        }
        String copied = this.copiedText;
        if (copied != null && copied.equals(contents)) {
            return;
        }
        MagnetOptions[] opts = MagnetOptions.parseMagnets(contents);
        if (opts.length == 0) {
            return;
        }
        LOG.info("clipboard contains " + contents);
        this.purgeClipboard();
        MagnetClipboardListener.handleMagnets(opts);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.clipboardParser.execute(this.parser);
    }

    private void purgeClipboard() {
        try {
            CLIPBOARD.setContents(this.empty, this.empty);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

