/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.filters.TableLineFilter;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.search.LabeledRangeSlider;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.search.SourceHolder;

public final class GeneralResultFilter
implements TableLineFilter<SearchResultDataLine> {
    private final SearchResultMediator _rp;
    private final LabeledRangeSlider _rangeSliderSeeds;
    private final LabeledRangeSlider _rangeSliderSize;
    private int _minResultsSeeds;
    private int _maxResultsSeeds;
    private double _minResultsSize;
    private double _maxResultsSize;
    private int _minSeeds;
    private int _maxSeeds;
    private int _minSize;
    private int _maxSize;
    private String _keywords;

    GeneralResultFilter(SearchResultMediator rp, LabeledRangeSlider rangeSliderSeeds, LabeledRangeSlider rangeSliderSize) {
        this._rp = rp;
        this._rangeSliderSeeds = rangeSliderSeeds;
        this._rangeSliderSize = rangeSliderSize;
        this._minResultsSeeds = Integer.MAX_VALUE;
        this._maxResultsSeeds = 0;
        this._minResultsSize = 9.223372036854776E18;
        this._maxResultsSize = 0.0;
        this._minSeeds = 0;
        this._maxSeeds = Integer.MAX_VALUE;
        this._minSize = 0;
        this._maxSize = Integer.MAX_VALUE;
    }

    @Override
    public boolean allow(SearchResultDataLine node) {
        boolean inSizeRange;
        boolean inSeedRange;
        boolean seedsNeedUpdate = false;
        int seeds = node.getSeeds();
        if (seeds < this._minResultsSeeds) {
            this._minResultsSeeds = Math.max(seeds, 0);
            seedsNeedUpdate = true;
        }
        if (seeds > this._maxResultsSeeds) {
            this._maxResultsSeeds = seeds;
            seedsNeedUpdate = true;
        }
        boolean sizeNeedUpdate = false;
        double size = node.getSize();
        if (size < this._minResultsSize) {
            this._minResultsSize = size >= 0.0 ? size : 0.0;
            sizeNeedUpdate = true;
        }
        if (size > this._maxResultsSize) {
            this._maxResultsSize = size;
            sizeNeedUpdate = true;
        }
        if (seedsNeedUpdate) {
            this._rangeSliderSeeds.getMinimumValueLabel().setText(String.valueOf(this._minResultsSeeds));
            this._rangeSliderSeeds.getMaximumValueLabel().setText(String.valueOf(this._maxResultsSeeds));
        }
        if (sizeNeedUpdate) {
            this._rangeSliderSize.getMinimumValueLabel().setText(GUIUtils.getBytesInHuman(this._minResultsSize));
            this._rangeSliderSize.getMaximumValueLabel().setText(GUIUtils.getBytesInHuman(this._maxResultsSize));
        }
        if (this._maxResultsSeeds > this._minResultsSeeds) {
            int seedNorm = (seeds - this._minResultsSeeds) * 1000 / (this._maxResultsSeeds - this._minResultsSeeds);
            inSeedRange = this._minSeeds == 0 && this._maxSeeds == 1000 ? true : (seeds == this._minSeeds || seeds == this._maxSeeds ? true : (this._minSeeds == 0 ? seedNorm <= this._maxSeeds : (this._maxSeeds == 1000 ? seedNorm >= this._minSeeds : seedNorm >= this._minSeeds && seedNorm <= this._maxSeeds)));
        } else {
            boolean bl = inSeedRange = seeds == this._maxResultsSeeds;
        }
        if (this._maxResultsSize > this._minResultsSize) {
            double sizeNorm = (size - this._minResultsSize) * 1000.0 / (this._maxResultsSize - this._minResultsSize);
            inSizeRange = this._minSize == 0 && this._maxSize == 1000 ? true : (this._minSize == 0 ? sizeNorm <= (double)this._maxSize : (this._maxSize == 1000 ? sizeNorm >= (double)this._minSize : sizeNorm >= (double)this._minSize && sizeNorm <= (double)this._maxSize));
        } else {
            inSizeRange = size == this._maxResultsSize;
        }
        String sourceName = this.getSourceName(node);
        boolean hasKeywords = this.hasKeywords(node.getDisplayName() + " " + node.getExtension() + " " + sourceName);
        return inSeedRange && inSizeRange && (hasKeywords || sourceName.contains("Cloud"));
    }

    private String getSourceName(SearchResultDataLine node) {
        SourceHolder sourceHolder = (SourceHolder)node.getValueAt(5);
        String sourceName = "";
        if (sourceHolder != null) {
            sourceName = sourceHolder.getSourceName();
        }
        return sourceName;
    }

    private boolean hasKeywords(String filename) {
        String keywordText = this._keywords;
        if (keywordText == null || keywordText.trim().length() == 0) {
            return true;
        }
        String[] keywords = keywordText.split(" ");
        if (keywords.length == 1) {
            return filename.toLowerCase().contains(keywordText.toLowerCase());
        }
        String fname = filename.toLowerCase();
        for (String k : keywords) {
            if (fname.contains(k.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    void setRangeSeeds(int min, int max) {
        this._minSeeds = min;
        this._maxSeeds = max;
        this._rp.filterChanged(this, 1);
    }

    void setRangeSize(int min, int max) {
        this._minSize = min;
        this._maxSize = max;
        this._rp.filterChanged(this, 1);
    }

    void updateKeywordFiltering(String text) {
        this._keywords = text;
        this._rp.filterChanged(this, 1);
    }
}

