/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.player.StreamMediaSource;
import com.frostwire.search.FileSearchResult;
import com.frostwire.search.SearchResult;
import com.frostwire.search.StreamableSearchResult;
import com.frostwire.search.soundcloud.SoundcloudSearchResult;
import com.frostwire.search.telluride.TellurideSearchResult;
import com.frostwire.search.yt.YTSearchResult;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.gui.search.UISearchResult;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.SearchSettings;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;

public abstract class AbstractUISearchResult
implements UISearchResult {
    private final FileSearchResult sr;
    private final SearchEngine se;
    private final String query;
    private final String extension;

    AbstractUISearchResult(FileSearchResult sr, SearchEngine se, String query) {
        this.sr = sr;
        this.se = se;
        this.query = query;
        this.extension = FilenameUtils.getExtension(sr.getFilename());
    }

    @Override
    public long getCreationTime() {
        return this.sr.getCreationTime();
    }

    @Override
    public String getFilename() {
        return this.sr.getFilename();
    }

    @Override
    public double getSize() {
        return this.sr.getSize();
    }

    @Override
    public String getSource() {
        return this.sr.getSource();
    }

    @Override
    public SearchEngine getSearchEngine() {
        return this.se;
    }

    @Override
    public String getDisplayName() {
        return this.sr.getDisplayName();
    }

    @Override
    public SearchResult getSearchResult() {
        return this.sr;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getDetailsUrl() {
        return this.sr.getDetailsUrl();
    }

    @Override
    public void showSearchResultWebPage(boolean now) {
        if (now) {
            GUIMediator.openURL(this.getSearchResult().getDetailsUrl());
        } else if (SearchSettings.SHOW_DETAIL_PAGE_AFTER_DOWNLOAD_START.getValue()) {
            GUIMediator.openURL(this.getSearchResult().getDetailsUrl(), 8000L);
        }
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void play() {
        if (this.sr instanceof StreamableSearchResult) {
            StreamableSearchResult ssr = (StreamableSearchResult)((Object)this.sr);
            if (SwingUtilities.isEventDispatchThread() && this.sr instanceof SoundcloudSearchResult) {
                SoundcloudSearchResult scsr = (SoundcloudSearchResult)this.sr;
                if (scsr.fetchedDownloadUrl()) {
                    this.playStream(ssr.getStreamUrl());
                } else {
                    BackgroundExecutorService.schedule(() -> {
                        String url = ssr.getStreamUrl();
                        GUIMediator.safeInvokeLater(() -> this.playStream(url));
                    });
                }
            } else {
                this.playStream(ssr.getStreamUrl());
            }
        } else if (this.sr instanceof TellurideSearchResult) {
            this.playStream(((TellurideSearchResult)this.sr).getDownloadUrl());
        } else if (this.sr instanceof YTSearchResult) {
            this.showSearchResultWebPage(true);
        }
    }

    private void playStream(String streamUrl) {
        MediaType mediaType = MediaType.getMediaTypeForExtension(this.extension);
        if (mediaType != null) {
            boolean isVideo = mediaType.equals(MediaType.getVideoMediaType());
            if (isVideo) {
                GUIMediator.instance().launchMedia(new StreamMediaSource(streamUrl, this.sr.getDisplayName(), this.sr.getDetailsUrl(), true), true);
            } else {
                GUIMediator.instance().launchMedia(new StreamMediaSource(streamUrl, this.sr.getDisplayName(), this.sr.getDetailsUrl(), false), true);
            }
        }
    }
}

