/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.URLHandlerSettings;
import javax.swing.JTextField;

public class VideoPlayerPaneItem
extends AbstractPaneItem {
    private static final String TITLE = I18n.tr("Video Options");
    private static final String LABEL = I18n.tr("You can choose which video player to use.");
    private final JTextField _playerField = new SizedTextField(25, GUIUtils.SizePolicy.RESTRICT_HEIGHT);

    public VideoPlayerPaneItem() {
        super(TITLE, LABEL);
        String OPTION_LABEL = I18n.tr("Video Player");
        LabeledComponent comp = new LabeledComponent(OPTION_LABEL, this._playerField);
        this.add(comp.getComponent());
    }

    @Override
    public boolean applyOptions() {
        URLHandlerSettings.VIDEO_PLAYER.setValue(this._playerField.getText());
        return false;
    }

    @Override
    public void initOptions() {
        this._playerField.setText(URLHandlerSettings.VIDEO_PLAYER.getValue());
    }

    @Override
    public boolean isDirty() {
        return !URLHandlerSettings.VIDEO_PLAYER.getValue().equals(this._playerField.getText());
    }
}

