/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.frostwire.bittorrent.BTEngine;
import com.frostwire.gui.bittorrent.TorrentSaveFolderComponent;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.LibrarySettings;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.io.IOException;

public final class TorrentSaveFolderPaneItem
extends AbstractPaneItem {
    private static final String TITLE = I18n.tr("Default Save Folder");
    private final TorrentSaveFolderComponent COMPONENT = new TorrentSaveFolderComponent(false);

    public TorrentSaveFolderPaneItem() {
        super(TITLE, I18n.tr("Choose the folder where downloads will be saved to"));
        this.add(this.COMPONENT);
    }

    @Override
    public void initOptions() {
    }

    @Override
    public boolean applyOptions() throws IOException {
        if (!this.COMPONENT.isTorrentSaveFolderPathValid(true)) {
            GUIMediator.showError(TorrentSaveFolderComponent.getError());
            throw new IOException();
        }
        boolean dirty = this.isDirty();
        if (dirty) {
            File newSaveFolder = new File(this.COMPONENT.getTorrentSaveFolderPath());
            this.updateLibraryFolders(newSaveFolder);
            this.updateDefaultSaveFolders(newSaveFolder);
        }
        return dirty;
    }

    private void updateLibraryFolders(File newSaveFolder) {
        LibrarySettings.DIRECTORIES_TO_INCLUDE.add(newSaveFolder);
        OptionsMediator.instance().reinitPane("OPTIONS_LIBRARY_MAIN_TITLE");
    }

    private void updateDefaultSaveFolders(File newSaveFolder) {
        SharingSettings.TORRENT_DATA_DIR_SETTING.setValue(newSaveFolder);
        BTEngine.getInstance().moveStorage(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue());
    }

    @Override
    public boolean isDirty() {
        return !SharingSettings.TORRENT_DATA_DIR_SETTING.getValueAsString().equals(this.COMPONENT.getTorrentSaveFolderPath());
    }
}

