/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.StatusBarSettings;
import javax.swing.JCheckBox;

public final class StatusBarFirewallPaneItem
extends AbstractPaneItem {
    private static final String TITLE = I18n.tr("Firewall Indicator");
    private static final String LABEL = I18n.tr("You can display your firewall status in the status bar.");
    private final JCheckBox CHECK_BOX = new JCheckBox();

    public StatusBarFirewallPaneItem() {
        super(TITLE, LABEL);
        String CHECK_BOX_LABEL = I18n.tr("Show Firewall Indicator:");
        LabeledComponent comp = new LabeledComponent(CHECK_BOX_LABEL, this.CHECK_BOX, 120, 10);
        this.add(comp.getComponent());
    }

    @Override
    public void initOptions() {
        this.CHECK_BOX.setSelected(StatusBarSettings.FIREWALL_DISPLAY_ENABLED.getValue());
    }

    @Override
    public boolean applyOptions() {
        if (!this.isDirty()) {
            return false;
        }
        StatusBarSettings.FIREWALL_DISPLAY_ENABLED.setValue(this.CHECK_BOX.isSelected());
        GUIMediator.instance().getStatusLine().refresh();
        return false;
    }

    @Override
    public boolean isDirty() {
        return StatusBarSettings.FIREWALL_DISPLAY_ENABLED.getValue() != this.CHECK_BOX.isSelected();
    }
}

