/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.PlayerSettings;
import javax.swing.JCheckBox;

public final class PlayerPaneItem
extends AbstractPaneItem {
    private static final String TITLE = I18n.tr("FrostWire Media Player");
    private static final String LABEL = I18n.tr("You can play your media with the native operating system player if the format is supported.");
    private final JCheckBox CHECK_BOX = new JCheckBox();
    private final JCheckBox VIDEO_PREVIEW_WITH_INTERNAL_PLAYER_CHECK_BOX = new JCheckBox();

    public PlayerPaneItem() {
        super(TITLE, LABEL);
        String CHECK_BOX_LABEL = I18n.tr("Play with the native media player");
        LabeledComponent comp = new LabeledComponent(CHECK_BOX_LABEL, this.CHECK_BOX, 120, 10);
        this.add(comp.getComponent());
        String VIDEO_PREVIEW_WITH_INTERNAL_PLAYER_CHECK_BOX_LABEL = I18n.tr("Play search result video previews with internal player");
        this.add(new LabeledComponent(VIDEO_PREVIEW_WITH_INTERNAL_PLAYER_CHECK_BOX_LABEL, this.VIDEO_PREVIEW_WITH_INTERNAL_PLAYER_CHECK_BOX, 120, 10).getComponent());
    }

    @Override
    public void initOptions() {
        this.CHECK_BOX.setSelected(PlayerSettings.USE_OS_DEFAULT_PLAYER.getValue());
        this.VIDEO_PREVIEW_WITH_INTERNAL_PLAYER_CHECK_BOX.setSelected(PlayerSettings.USE_FW_PLAYER_FOR_CLOUD_VIDEO_PREVIEWS.getValue());
    }

    @Override
    public boolean applyOptions() {
        PlayerSettings.USE_OS_DEFAULT_PLAYER.setValue(this.CHECK_BOX.isSelected());
        PlayerSettings.USE_FW_PLAYER_FOR_CLOUD_VIDEO_PREVIEWS.setValue(this.VIDEO_PREVIEW_WITH_INTERNAL_PLAYER_CHECK_BOX.isSelected());
        return false;
    }

    @Override
    public boolean isDirty() {
        return PlayerSettings.USE_OS_DEFAULT_PLAYER.getValue() != this.CHECK_BOX.isSelected() || PlayerSettings.USE_FW_PLAYER_FOR_CLOUD_VIDEO_PREVIEWS.getValue() != this.VIDEO_PREVIEW_WITH_INTERNAL_PLAYER_CHECK_BOX.isSelected();
    }
}

