/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.UISettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class ExperimentalFeaturesPaneItem
extends AbstractPaneItem {
    private final JCheckBox alphaCheckbox;
    private final JCheckBox betaCheckbox;
    private final JLabel note;
    private final boolean initialAlphaValue = FrostWireUtils.isIsRunningFromSource() || UISettings.ALPHA_FEATURES_ENABLED.getValue();
    private final boolean initialBetaValue = FrostWireUtils.isIsRunningFromSource() || UISettings.BETA_FEATURES_ENABLED.getValue();

    public ExperimentalFeaturesPaneItem() {
        super(I18n.tr("Experimental Features"), I18n.tr("Warning: These experimental features may change, break, or disappear at any time. We make absolutely no guarantees about what may happen if you turn one of these experiments on. FrostWire may delete all your data, or your security and privacy could be compromised in unexpected ways. Please procede with caution."));
        this.alphaCheckbox = new JCheckBox();
        this.betaCheckbox = new JCheckBox();
        this.note = new JLabel(I18n.tr("Note: All features are enabled by default when running FrostWire from source"));
        this.note.setVisible(false);
    }

    @Override
    public boolean isDirty() {
        return this.initialAlphaValue != this.alphaCheckbox.isSelected() || this.initialBetaValue != this.betaCheckbox.isSelected();
    }

    @Override
    public void initOptions() {
        this.alphaCheckbox.setText("<html><strong>" + I18n.tr("Enable ALPHA features") + "</strong>. " + I18n.tr("Bleeding edge, unstable, tested by developers only, very risky.") + "</html>");
        this.betaCheckbox.setText("<html><strong>" + I18n.tr("Enable BETA features") + "</strong>. " + I18n.tr("Feature complete, unknown bugs, tested by QA, somewhat risky.") + "</html>");
        this.alphaCheckbox.setSelected(this.initialAlphaValue);
        this.betaCheckbox.setSelected(this.initialBetaValue);
        this.add(this.alphaCheckbox);
        this.add(this.betaCheckbox);
        this.add(this.note);
        if (FrostWireUtils.isIsRunningFromSource()) {
            this.alphaCheckbox.setEnabled(false);
            this.betaCheckbox.setEnabled(false);
            this.note.setVisible(true);
        }
    }

    @Override
    public boolean applyOptions() {
        if (FrostWireUtils.isIsRunningFromSource()) {
            return false;
        }
        UISettings.ALPHA_FEATURES_ENABLED.setValue(this.alphaCheckbox.isSelected());
        UISettings.BETA_FEATURES_ENABLED.setValue(this.betaCheckbox.isSelected());
        return this.isDirty();
    }
}

