/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.notify;

import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.notify.NotifyUser;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public final class TrayNotifier
implements NotifyUser {
    private SystemTray _tray;
    private TrayIcon _icon;
    private final boolean _supportsTray;

    public TrayNotifier() {
        try {
            this._tray = SystemTray.getSystemTray();
        }
        catch (Exception e) {
            this._tray = null;
            this._supportsTray = false;
            return;
        }
        this._supportsTray = true;
        this.buildPopupMenu();
        Object iconFileName = "frosticon";
        if (OSUtils.isLinux()) {
            iconFileName = (String)iconFileName + "_linux";
        }
        this.buildTrayIcon((String)iconFileName);
    }

    private void buildTrayIcon(String imageFileName) {
        this._icon = new TrayIcon(GUIMediator.getThemeImage(imageFileName).getImage(), "FrostWire", GUIMediator.getTrayMenu());
        this._icon.addMouseListener(new MouseAdapter(this){

            @Override
            public void mousePressed(MouseEvent e) {
                if ((e.getModifiersEx() & 0x400) == 1024) {
                    GUIMediator.restoreView();
                }
            }
        });
        this._icon.addActionListener(e -> GUIMediator.restoreView());
        this._icon.setImageAutoSize(true);
    }

    private void buildPopupMenu() {
        PopupMenu menu = GUIMediator.getTrayMenu();
        MenuItem item = new MenuItem(I18n.tr("Restore"));
        item.addActionListener(e -> GUIMediator.restoreView());
        menu.add(item);
        menu.addSeparator();
        item = new MenuItem(I18n.tr("About"));
        item.addActionListener(e -> GUIMediator.showAboutWindow());
        menu.add(item);
        menu.addSeparator();
        item = new MenuItem(I18n.tr("Exit"));
        item.addActionListener(e -> GUIMediator.shutdown());
        menu.add(item);
    }

    @Override
    public boolean showTrayIcon() {
        if (this._tray == null || !this.supportsSystemTray()) {
            return false;
        }
        try {
            this._tray.add(this._icon);
        }
        catch (Exception iae) {
            return false;
        }
        return true;
    }

    @Override
    public boolean supportsSystemTray() {
        return this._supportsTray;
    }

    @Override
    public void hideTrayIcon() {
        this._tray.remove(this._icon);
    }
}

