/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LanguageWindow;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.actions.ToggleSettingAction;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.limewire.setting.BooleanSetting;

final class ViewMenu
extends AbstractMenu {
    ViewMenu() {
        super(I18n.tr("&View"));
        this.addToggleMenuItem(new SearchTransfersSplitTabsAction(UISettings.UI_SEARCH_TRANSFERS_SPLIT_VIEW, I18n.tr("&Search/Transfers split screen")));
        this.addToggleMenuItem(new ToggleIconSettingAction(UISettings.SMALL_ICONS, I18n.tr("Use &Small Icons"), I18n.tr("Use Small Icons")));
        this.addToggleMenuItem(new ToggleIconSettingAction(UISettings.TEXT_WITH_ICONS, I18n.tr("Show Icon &Text"), I18n.tr("Show Text Below Icons")));
        this.MENU.addSeparator();
        this.addMenuItem(new ChangeFontSizeAction(1, I18n.tr("&Increase Font Size"), I18n.tr("Increases the Table Font Size")), KeyStroke.getKeyStroke(521, OSUtils.isMacOSX() ? 256 : 128));
        this.addMenuItem(new ChangeFontSizeAction(-1, I18n.tr("&Decrease Font Size"), I18n.tr("Decreases the Table Font Size")), KeyStroke.getKeyStroke(45, OSUtils.isMacOSX() ? 256 : 128));
        this.MENU.addSeparator();
        this.addMenuItem(new ShowLanguageWindowAction());
    }

    private static class SearchTransfersSplitTabsAction
    extends ToggleSettingAction {
        SearchTransfersSplitTabsAction(BooleanSetting setting, String name) {
            super(setting, name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            GUIMediator.showMessage(I18n.tr("This preference will take effect next time you restart FrostWire"));
        }
    }

    private static class ToggleIconSettingAction
    extends ToggleSettingAction {
        ToggleIconSettingAction(BooleanSetting setting, String name, String description) {
            super(setting, name, description);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            GUIMediator.instance().buttonViewChanged();
        }
    }

    private static class ChangeFontSizeAction
    extends AbstractAction {
        private final int increment;

        ChangeFontSizeAction(int inc, String name, String description) {
            super(name);
            this.putValue("LongDescription", description);
            this.increment = inc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ThemeMediator.modifyTablesFont(this.increment);
        }
    }

    private static class ShowLanguageWindowAction
    extends AbstractAction {
        ShowLanguageWindowAction() {
            super(I18n.tr("C&hange Language"));
            this.putValue("LongDescription", I18n.tr("Select your Language Prefereces"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LanguageWindow lw = new LanguageWindow();
            GUIUtils.centerOnScreen(lw);
            lw.setVisible(true);
        }
    }
}

