/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.frostwire.gui.updates.UpdateMediator;
import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import java.awt.event.ActionEvent;

final class ToolsMenu
extends AbstractMenu {
    private final UpdateAction updateAction = new UpdateAction();

    ToolsMenu() {
        super(I18n.tr("&Tools"));
        if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
            this.addMenuItem(new RebuildiTunesPlaylist());
        }
        this.addMenuItem(new ShowOptionsAction());
        this.addMenuItem(this.updateAction);
    }

    @Override
    protected void refresh() {
        this.updateAction.refresh();
    }

    private static class UpdateAction
    extends AbstractAction {
        private static final long serialVersionUID = 2915214339056016808L;

        UpdateAction() {
            super(I18n.tr("&Update FrostWire"));
            this.putValue("LongDescription", I18n.tr("Update FrostWire to the latest version"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (UpdateMediator.instance().isUpdateDownloaded()) {
                UpdateMediator.instance().startUpdate();
            } else {
                UpdateMediator.instance().checkForUpdate();
            }
        }

        void refresh() {
            Object text;
            boolean enabled = true;
            if (UpdateMediator.instance().isUpdated()) {
                text = I18n.tr("You are up to date with FrostWire") + " v." + UpdateMediator.instance().getLatestVersion();
            } else if (UpdateMediator.instance().isUpdateDownloading()) {
                text = I18n.tr("Downloading update...") + "(" + UpdateMediator.instance().getUpdateDownloadProgress() + "%)";
                enabled = false;
            } else {
                text = UpdateMediator.instance().isUpdateDownloaded() ? I18n.tr("Install update") + " v." + UpdateMediator.instance().getLatestVersion() : I18n.tr("Check for update");
            }
            this.putValue("Name", text);
            this.putValue("LongDescription", text);
            this.setEnabled(enabled);
        }
    }

    private static class RebuildiTunesPlaylist
    extends AbstractAction {
        private static final long serialVersionUID = 8348355619323878579L;
        private static final String actionTitle = OSUtils.isMacOSCatalina105OrNewer() ? I18n.tr("Rebuild Apple Music \"FrostWire\" Playlist") : I18n.tr("Rebuild iTunes \"FrostWire\" Playlist");
        private static final String description = OSUtils.isMacOSCatalina105OrNewer() ? I18n.tr("Deletes and re-builds the \"FrostWire\" playlist on Apple Music with all the audio files found on your Torrent Data Folder.") : I18n.tr("Deletes and re-builds the \"FrostWire\" playlist on iTunes with all the audio files found on your Torrent Data Folder.");

        RebuildiTunesPlaylist() {
            super(actionTitle);
            this.putValue("LongDescription", description);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String yesNoMessage = OSUtils.isMacOSCatalina105OrNewer() ? I18n.tr("This will remove your \"FrostWire\" playlist in Apple Music and replace\nit with one containing all the Apple Music compatible files in your \nFrostwire \"Torrent Data Folder\"\n\nPlease note that it will add the files to the Apple Music library as well\nand this could result in duplicate files on your Apple Music library\n\nAre you sure you want to continue?") : I18n.tr("This will remove your \"FrostWire\" playlist in iTunes and replace\nit with one containing all the iTunes compatible files in your \nFrostwire \"Torrent Data Folder\"\n\nPlease note that it will add the files to the iTunes library as well\nand this could result in duplicate files on your iTunes library\n\nAre you sure you want to continue?");
            DialogOption result = GUIMediator.showYesNoMessage(yesNoMessage, I18n.tr("Warning"), 2);
            if (result == DialogOption.YES) {
                iTunesMediator.instance().resetFrostWirePlaylist();
            }
        }
    }

    private static class ShowOptionsAction
    extends AbstractAction {
        private static final long serialVersionUID = 6187597973189408647L;

        ShowOptionsAction() {
            super(I18n.tr("&Options"));
            this.putValue("LongDescription", I18n.tr("Display the Options Screen"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GUIMediator.instance().setOptionsVisible(true);
        }
    }
}

