/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.actions.ToggleSettingAction;
import com.limegroup.gnutella.gui.menu.Menu;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

abstract class AbstractMenu
implements Menu {
    final JMenu MENU;

    AbstractMenu(String name) {
        this.MENU = new JMenu(new MenuAction(name));
        this.MENU.addMenuListener(new RefreshMenuListener());
    }

    @Override
    public JMenu getMenu() {
        return this.MENU;
    }

    JMenuItem addMenuItem(Action action) {
        return this.addMenuItem(action, null);
    }

    JMenuItem addMenuItem(Action action, KeyStroke acceleratorKeyStroke) {
        JMenuItem item = new JMenuItem(action);
        if (acceleratorKeyStroke != null) {
            item.setAccelerator(acceleratorKeyStroke);
        }
        this.MENU.add(item);
        return item;
    }

    private JMenuItem addToggleMenuItem(Action action, boolean selected) {
        JMenuItem item = OSUtils.isMacOSX() ? new JRadioButtonMenuItem(action) : new JCheckBoxMenuItem(action);
        item.setSelected(selected);
        this.MENU.add(item);
        return item;
    }

    JMenuItem addToggleMenuItem(ToggleSettingAction action) {
        return this.addToggleMenuItem(action, action.getSetting().getValue());
    }

    void addSeparator() {
        this.MENU.addSeparator();
    }

    void refresh() {
    }

    private static class MenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -4311768902578846258L;

        MenuAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private class RefreshMenuListener
    implements MenuListener {
        private RefreshMenuListener() {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            AbstractMenu.this.refresh();
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }
}

