/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconButton;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

class SocialRecommendationsWindow
extends SetupWindow {
    SocialRecommendationsWindow(SetupManager manager) {
        super(manager, I18n.tr("Join us."), I18n.tr("Join the FrostWire community and help us spread FrostWire to continue to have a free and uncensored Internet. Stay in touch through social media channels for quick feedback, support, ideas or just to say hello."));
    }

    @Override
    protected void createWindow() {
        super.createWindow();
        JPanel mainPanel = new JPanel(new MigLayout("fillx, insets 0, gap 4px", "[]"));
        mainPanel.add((Component)new IconButton("SOCIAL_MEDIA_CHECK", 150, 150), "growx, center, span, wrap");
        mainPanel.add((Component)new JLabel(I18n.tr("<html><b>Keep in Touch!</b></html>")), "center, span, wrap, height 40px");
        int socialButtonW = 100;
        mainPanel.add((Component)this.createSocialButton("SOCIAL_WIZARD_TWITTER", "https://twitter.com/frostwire", socialButtonW), "alignx center");
        mainPanel.add((Component)this.createSocialButton("SOCIAL_WIZARD_FACEBOOK", "https://www.facebook.com/FrostwireOfficial", socialButtonW), "alignx center");
        mainPanel.add((Component)this.createSocialButton("SOCIAL_WIZARD_REDDIT", "https://www.reddit.com/r/frostwire", socialButtonW), "alignx center");
        this.setSetupComponent(mainPanel);
    }

    private IconButton createSocialButton(String iconName, String clickURL, int height) {
        IconButton button = new IconButton(iconName, height, height);
        button.addActionListener(e -> GUIMediator.openURL(clickURL));
        return button;
    }
}

