/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.WindowsUtils;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.MacOSXUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

final class MiscWindow
extends SetupWindow {
    private JCheckBox _startup;

    MiscWindow(SetupManager manager) {
        super(manager, I18n.tr("Miscellaneous Settings"), I18n.tr("Below, are several options that affect the functionality of FrostWire."));
    }

    @Override
    protected void createWindow() {
        GridBagConstraints gbc;
        super.createWindow();
        JPanel mainPanel = new JPanel(new GridBagLayout());
        if (GUIUtils.shouldShowStartOnStartupWindow()) {
            gbc = new GridBagConstraints();
            JPanel startupPanel = new JPanel(new GridBagLayout());
            startupPanel.setBorder(ThemeMediator.createTitledBorder(I18n.tr("System Startup")));
            this._startup = new JCheckBox(I18n.tr("Start Automatically"));
            this._startup.setSelected(StartupSettings.RUN_ON_STARTUP.getValue());
            JLabel desc = new JLabel("<html>" + I18n.tr("Would you like FrostWire to start when you log into your computer? This will cause FrostWire to start faster when you use it later.") + "</html>");
            desc.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 5));
            desc.setForeground(Color.BLACK);
            desc.setFont(desc.getFont().deriveFont(0));
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            startupPanel.add((Component)desc, gbc);
            startupPanel.add((Component)this._startup, gbc);
            gbc.insets = new Insets(0, 0, 10, 0);
            mainPanel.add((Component)startupPanel, gbc);
            startupPanel.putClientProperty("skin_property_dark_box_background", Boolean.TRUE);
        }
        gbc = new GridBagConstraints();
        gbc.fill = 3;
        gbc.weighty = 1.0;
        gbc.gridwidth = 0;
        mainPanel.add((Component)new JPanel(), gbc);
        this.setSetupComponent(mainPanel);
    }

    @Override
    public void applySettings(boolean loadCoreComponents) {
        if (GUIUtils.shouldShowStartOnStartupWindow()) {
            boolean allow = this._startup.isSelected();
            if (OSUtils.isMacOSX()) {
                MacOSXUtils.setLoginStatus(allow);
            } else if (WindowsUtils.isLoginStatusAvailable()) {
                WindowsUtils.setLoginStatus(allow);
            }
            StartupSettings.RUN_ON_STARTUP.setValue(allow);
        }
    }
}

